/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UseOfSunClassesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("use.sun.classes.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("use.sun.classes.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfSunClassesVisitor();
    }

    private static class UseOfSunClassesVisitor
    extends BaseInspectionVisitor {
        private UseOfSunClassesVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            PsiType type2 = variable.getType();
            PsiType deepComponentType = type2.getDeepComponentType();
            if (!(deepComponentType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)deepComponentType;
            String className = classType.getCanonicalText();
            if (className == null || !className.startsWith("sun.")) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            super.visitNewExpression(newExpression);
            PsiType type2 = newExpression.getType();
            if (type2 == null) {
                return;
            }
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            String className = classType.getCanonicalText();
            if (className == null || !className.startsWith("sun.")) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }
    }
}

