/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression2) {
        if (!(expression2 instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression2;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiExpression ancestor = exp;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression expression2) {
        if (!(expression2 instanceof PsiPrefixExpression)) {
            return null;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!JavaTokenType.EXCL.equals(tokenType)) {
            return null;
        }
        PsiExpression operand2 = prefixExpression.getOperand();
        return ParenthesesUtils.stripParentheses(operand2);
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition2) {
        return BoolUtils.getNegatedExpressionText(condition2, 17);
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression expression2, int precedence) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return "";
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            boolean needParenthesis = ParenthesesUtils.getPrecedence((PsiExpression)conditionalExpression) >= precedence;
            String text = conditionalExpression.getCondition().getText() + '?' + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression()) + ':' + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression());
            return needParenthesis ? "(" + text + ")" : text;
        }
        if (BoolUtils.isNegation(expression2)) {
            PsiExpression negated = BoolUtils.getNegated(expression2);
            if (negated == null) {
                return "";
            }
            return ParenthesesUtils.getText(negated, precedence);
        }
        if (ComparisonUtils.isComparison(expression2)) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            String negatedComparison = ComparisonUtils.getNegatedComparison(polyadicExpression.getOperationTokenType());
            StringBuilder result2 = new StringBuilder();
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            boolean isEven = (operands2.length & 1) != 1;
            int length = operands2.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiExpression operand2 = operands2[i2];
                if (TypeUtils.hasFloatingPointType(operand2)) {
                    return "!(" + polyadicExpression.getText() + ')';
                }
                if (i2 > 0) {
                    if (isEven && (i2 & 1) != 1) {
                        PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand2);
                        if (token != null) {
                            result2.append(token.getText());
                        }
                    } else {
                        result2.append(negatedComparison);
                    }
                }
                result2.append(operand2.getText());
            }
            return result2.toString();
        }
        return '!' + ParenthesesUtils.getText(expression2, 3);
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression expression2) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = expression2;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        if (parent instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isBooleanLiteral(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
        String text = literalExpression.getText();
        return "true".equals(text) || "false".equals(text);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isTrue(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return false;
        }
        return "true".equals(expression2.getText());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFalse(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return false;
        }
        return "false".equals(expression2.getText());
    }
}

