/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CommentTracker {
    private Set<PsiElement> ignoredParents = new HashSet<PsiElement>();
    private List<PsiComment> comments = new ArrayList<PsiComment>();

    @NotNull
    public String text(@NotNull PsiElement element) {
        this.checkState();
        this.addIgnored(element);
        return element.getText();
    }

    @NotNull
    public <T extends PsiElement> T markUnchanged(@NotNull T element) {
        this.checkState();
        this.addIgnored(element);
        return element;
    }

    public void delete(@NotNull PsiElement element) {
        this.grabComments(element);
        element.delete();
    }

    public void delete(PsiElement ... elements) {
        for (PsiElement element : elements) {
            this.delete(element);
        }
    }

    public void deleteAndRestoreComments(@NotNull PsiElement element) {
        this.grabComments(element);
        this.insertCommentsBefore(element instanceof PsiVariable ? element.getParent() : element);
        element.delete();
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        this.grabComments(element);
        return element.replace(replacement);
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull String text) {
        PsiElement replacement = CommentTracker.createElement(element, text);
        return this.replace(element, replacement);
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        PsiElement result2 = this.replace(element, replacement);
        PsiElement anchor = PsiTreeUtil.getNonStrictParentOfType((PsiElement)result2, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class, PsiVariable.class});
        if (anchor instanceof PsiLambdaExpression && anchor != result2) {
            anchor = ((PsiLambdaExpression)anchor).getBody();
        }
        if (anchor instanceof PsiVariable && anchor.getParent() instanceof PsiDeclarationStatement) {
            anchor = anchor.getParent();
        }
        if (anchor == null) {
            anchor = result2;
        }
        this.insertCommentsBefore(anchor);
        return result2;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull String text) {
        PsiElement replacement = CommentTracker.createElement(element, text);
        return this.replaceAndRestoreComments(element, replacement);
    }

    @NotNull
    private static PsiElement createElement(@NotNull PsiElement element, @NotNull String text) {
        PsiExpression replacement;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        if (element instanceof PsiExpression) {
            replacement = factory.createExpressionFromText(text, element);
        } else if (element instanceof PsiStatement) {
            replacement = factory.createStatementFromText(text, element);
        } else if (element instanceof PsiTypeElement) {
            replacement = factory.createTypeElementFromText(text, element);
        } else if (element instanceof PsiIdentifier) {
            replacement = factory.createIdentifier(text);
        } else if (element instanceof PsiComment) {
            replacement = factory.createCommentFromText(text, element);
        } else {
            throw new IllegalArgumentException("Unsupported element type: " + element);
        }
        return replacement;
    }

    public void insertCommentsBefore(@NotNull PsiElement anchor) {
        this.checkState();
        if (!this.comments.isEmpty()) {
            PsiElement parent = anchor.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
            for (PsiComment comment : this.comments) {
                PsiElement added;
                PsiElement prevSibling;
                if (this.shouldIgnore(comment) || !((prevSibling = (added = parent.addBefore((PsiElement)factory.createCommentFromText(comment.getText(), anchor), anchor)).getPrevSibling()) instanceof PsiWhiteSpace)) continue;
                ASTNode whiteSpaceBefore = CommentTracker.normalizeWhiteSpace((PsiWhiteSpace)prevSibling);
                PsiElement prev = anchor.getPrevSibling();
                parent.getNode().addChild(whiteSpaceBefore, anchor.getNode());
                if (!(prev instanceof PsiWhiteSpace)) continue;
                prev.delete();
            }
        }
        this.comments = null;
    }

    @NotNull
    private static ASTNode normalizeWhiteSpace(PsiWhiteSpace whiteSpace) {
        int endLPos;
        String text = whiteSpace.getText();
        if (text.lastIndexOf(10, (endLPos = text.lastIndexOf(10)) - 1) >= 0) {
            return ASTFactory.whitespace(text.substring(endLPos));
        }
        return ASTFactory.whitespace(text);
    }

    private boolean shouldIgnore(PsiComment comment) {
        return this.ignoredParents.stream().anyMatch(p -> PsiTreeUtil.isAncestor((PsiElement)p, (PsiElement)comment, (boolean)false));
    }

    private void grabComments(PsiElement element) {
        this.checkState();
        for (PsiComment comment : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class})) {
            if (this.shouldIgnore(comment)) continue;
            this.comments.add(comment);
        }
    }

    private void checkState() {
        if (this.comments == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already used");
        }
    }

    private void addIgnored(PsiElement element) {
        if (element instanceof LeafPsiElement && !(element instanceof PsiComment)) {
            return;
        }
        this.ignoredParents.add(element);
    }

    public static String textWithSurroundingComments(PsiElement element) {
        Predicate<PsiElement> commentOrWhiteSpace = e -> e instanceof PsiComment || e instanceof PsiWhiteSpace;
        List prev = StreamEx.iterate((Object)element.getPrevSibling(), commentOrWhiteSpace, PsiElement::getPrevSibling).toList();
        List next = StreamEx.iterate((Object)element.getNextSibling(), commentOrWhiteSpace, PsiElement::getNextSibling).toList();
        if (StreamEx.of((Object[])new List[]{prev, next}).flatCollection(Function.identity()).anyMatch(PsiComment.class::isInstance)) {
            return StreamEx.ofReversed((List)prev).append((Object)element).append((Collection)next).map(PsiElement::getText).joining();
        }
        return element.getText();
    }
}

