/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountingLoop {
    @NotNull
    final PsiLocalVariable myCounter;
    @NotNull
    final PsiLoopStatement myLoop;
    @NotNull
    final PsiExpression myInitializer;
    @NotNull
    final PsiExpression myBound;
    final boolean myIncluding;

    private CountingLoop(@NotNull PsiLoopStatement loop, @NotNull PsiLocalVariable counter, @NotNull PsiExpression initializer, @NotNull PsiExpression bound, boolean including) {
        this.myInitializer = initializer;
        this.myCounter = counter;
        this.myLoop = loop;
        this.myBound = bound;
        this.myIncluding = including;
    }

    @NotNull
    public PsiLocalVariable getCounter() {
        return this.myCounter;
    }

    @NotNull
    public PsiLoopStatement getLoop() {
        return this.myLoop;
    }

    @NotNull
    public PsiExpression getInitializer() {
        return this.myInitializer;
    }

    @NotNull
    public PsiExpression getBound() {
        return this.myBound;
    }

    public boolean isIncluding() {
        return this.myIncluding;
    }

    @Nullable
    public static CountingLoop from(PsiForStatement forStatement) {
        PsiExpression ref;
        PsiExpression bound;
        PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)forStatement.getInitialization(), PsiDeclarationStatement.class);
        if (initialization == null || initialization.getDeclaredElements().length != 1) {
            return null;
        }
        PsiLocalVariable counter = (PsiLocalVariable)ObjectUtils.tryCast((Object)initialization.getDeclaredElements()[0], PsiLocalVariable.class);
        if (counter == null) {
            return null;
        }
        if (!counter.getType().equals(PsiType.INT) && !counter.getType().equals(PsiType.LONG)) {
            return null;
        }
        PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)counter.getInitializer());
        if (initializer == null) {
            return null;
        }
        if (!VariableAccessUtils.variableIsIncremented((PsiVariable)counter, forStatement.getUpdate())) {
            return null;
        }
        PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)forStatement.getCondition(), PsiBinaryExpression.class);
        if (condition2 == null) {
            return null;
        }
        IElementType type2 = condition2.getOperationTokenType();
        boolean closed = false;
        if (type2.equals(JavaTokenType.LE)) {
            bound = condition2.getROperand();
            ref = condition2.getLOperand();
            closed = true;
        } else if (type2.equals(JavaTokenType.LT)) {
            bound = condition2.getROperand();
            ref = condition2.getLOperand();
        } else if (type2.equals(JavaTokenType.GE)) {
            bound = condition2.getLOperand();
            ref = condition2.getROperand();
            closed = true;
        } else if (type2.equals(JavaTokenType.GT)) {
            bound = condition2.getLOperand();
            ref = condition2.getROperand();
        } else {
            return null;
        }
        if (bound == null || !ExpressionUtils.isReferenceTo(ref, (PsiVariable)counter)) {
            return null;
        }
        if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)counter.getType(), (PsiExpression)bound)) {
            return null;
        }
        return new CountingLoop((PsiLoopStatement)forStatement, counter, initializer, bound, closed);
    }
}

