/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.DefiniteAssignment;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefiniteAssignmentUtil {
    public static void checkVariable(PsiVariable variable, DefiniteAssignment definiteAssignment) {
        if (variable.getInitializer() != null) {
            throw new IllegalArgumentException("variable has initializer, check for assignment to the field");
        }
        if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            DefiniteAssignmentUtil.checkField(field, definiteAssignment);
        } else {
            if (variable instanceof PsiParameter) {
                throw new IllegalArgumentException("parameter has implicit initializer, check for assignment to the parameter");
            }
            if (variable instanceof PsiLocalVariable) {
                PsiLocalVariable localVariable = (PsiLocalVariable)variable;
                PsiElement parent = localVariable.getParent();
                assert (parent instanceof PsiDeclarationStatement);
                PsiStatement statement2 = (PsiStatement)parent;
                while (statement2 != null) {
                    DefiniteAssignmentUtil.checkStatement(statement2, definiteAssignment);
                    statement2 = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
                }
            } else assert (false);
        }
    }

    private static void checkField(PsiField field, DefiniteAssignment definiteAssignment) {
        PsiMethod[] constructors;
        PsiClass aClass;
        if (field.getInitializer() != null) {
            definiteAssignment.set(true, false);
        }
        if ((aClass = field.getContainingClass()) == null) {
            return;
        }
        PsiElement[] children2 = aClass.getChildren();
        boolean isStatic = field.hasModifierProperty("static");
        for (PsiElement child : children2) {
            PsiClassInitializer classInitializer;
            if (child instanceof PsiField) {
                PsiField otherField = (PsiField)child;
                if (otherField.hasModifierProperty("static") != isStatic) continue;
                DefiniteAssignmentUtil.checkExpression(otherField.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
                continue;
            }
            if (!(child instanceof PsiClassInitializer) || (classInitializer = (PsiClassInitializer)child).hasModifierProperty("static") != isStatic) continue;
            DefiniteAssignmentUtil.checkCodeBlock(classInitializer.getBody(), definiteAssignment);
        }
        if (!isStatic && (constructors = aClass.getConstructors()).length != 0) {
            boolean da = definiteAssignment.isDefinitelyAssigned();
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            boolean resultDa = true;
            boolean resultDu = true;
            for (PsiMethod constructor : constructors) {
                DefiniteAssignmentUtil.checkConstructor(constructor, definiteAssignment);
                resultDa &= definiteAssignment.isDefinitelyAssigned();
                resultDu &= definiteAssignment.isDefinitelyUnassigned();
                if (definiteAssignment.stop()) {
                    return;
                }
                definiteAssignment.set(da, du);
            }
            definiteAssignment.set(resultDa, resultDu);
        }
    }

    private static boolean isAlternateConstructorInvocation(PsiStatement statement2) {
        return DefiniteAssignmentUtil.isConstructorInvocation(statement2, "this");
    }

    private static boolean isSuperClassConstructorInvocation(PsiStatement statement2) {
        return DefiniteAssignmentUtil.isConstructorInvocation(statement2, "super");
    }

    private static boolean isConstructorInvocation(PsiStatement statement2, @NotNull String keyword) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression2 = expressionStatement.getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        return keyword.equals(methodExpression.getReferenceName());
    }

    private static void checkAnonymousClass(PsiAnonymousClass anonymousClass, DefiniteAssignment definiteAssignment) {
        PsiClassInitializer[] initializers;
        for (PsiField field : anonymousClass.getFields()) {
            DefiniteAssignmentUtil.checkExpression(field.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
        for (PsiClassInitializer initializer : initializers = anonymousClass.getInitializers()) {
            DefiniteAssignmentUtil.checkCodeBlock(initializer.getBody(), definiteAssignment);
        }
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        for (PsiMethod method2 : anonymousClass.getMethods()) {
            definiteAssignment.set(true, false);
            DefiniteAssignmentUtil.checkCodeBlock(method2.getBody(), definiteAssignment);
        }
        definiteAssignment.set(da, du);
    }

    private static void checkClass(PsiClass aClass, DefiniteAssignment definiteAssignment) {
        for (PsiField psiField : aClass.getFields()) {
            DefiniteAssignmentUtil.checkExpression(psiField.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
        for (PsiField psiField : aClass.getInitializers()) {
            DefiniteAssignmentUtil.checkCodeBlock(psiField.getBody(), definiteAssignment);
        }
        for (PsiField psiField : aClass.getMethods()) {
            DefiniteAssignmentUtil.checkCodeBlock(psiField.getBody(), definiteAssignment);
        }
        for (PsiField psiField : aClass.getInnerClasses()) {
            DefiniteAssignmentUtil.checkClass((PsiClass)psiField, definiteAssignment);
        }
    }

    private static void checkConstructor(PsiMethod constructor, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(false, true);
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 == null) {
            return;
        }
        PsiStatement[] statements = body2.getStatements();
        boolean superCalled = false;
        for (int i2 = 0; i2 < statements.length; ++i2) {
            PsiStatement statement2 = statements[i2];
            if (i2 == 0) {
                if (DefiniteAssignmentUtil.isAlternateConstructorInvocation(statement2)) {
                    DefiniteAssignmentUtil.checkStatement(statement2, definiteAssignment);
                    definiteAssignment.set(true, false);
                    superCalled = true;
                    continue;
                }
                if (DefiniteAssignmentUtil.isSuperClassConstructorInvocation(statement2)) {
                    DefiniteAssignmentUtil.checkStatement(statement2, definiteAssignment);
                    definiteAssignment.set(da, du);
                    superCalled = true;
                    continue;
                }
            }
            if (!superCalled) {
                definiteAssignment.set(da, du);
                superCalled = true;
            }
            DefiniteAssignmentUtil.checkStatement(statement2, definiteAssignment);
        }
        if (!superCalled) {
            definiteAssignment.set(da, du);
        }
        definiteAssignment.andDefiniteAssignmentBeforeReturn(constructor);
    }

    private static void checkCodeBlock(@Nullable PsiCodeBlock codeBlock, DefiniteAssignment definiteAssignment) {
        if (codeBlock == null) {
            return;
        }
        for (PsiStatement statement2 : codeBlock.getStatements()) {
            DefiniteAssignmentUtil.checkStatement(statement2, definiteAssignment);
        }
    }

    private static void checkLocalVariable(PsiLocalVariable localVariable, DefiniteAssignment definiteAssignment) {
        PsiExpression initializer = localVariable.getInitializer();
        if (initializer != null && definiteAssignment.getVariable() == localVariable) {
            definiteAssignment.set(true, false);
        }
        DefiniteAssignmentUtil.checkExpression(initializer, definiteAssignment, BooleanExpressionValue.UNDEFINED);
    }

    private static void checkStatement(@Nullable PsiStatement statement2, DefiniteAssignment definiteAssignment) {
        if (statement2 == null || definiteAssignment.stop() || statement2 instanceof PsiEmptyStatement) {
            return;
        }
        if (statement2 instanceof PsiAssertStatement) {
            PsiAssertStatement assertStatement = (PsiAssertStatement)statement2;
            DefiniteAssignmentUtil.checkAssertStatement(assertStatement, definiteAssignment);
        } else if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            DefiniteAssignmentUtil.checkCodeBlock(blockStatement.getCodeBlock(), definiteAssignment);
        } else if (statement2 instanceof PsiBreakStatement) {
            PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
            DefiniteAssignmentUtil.checkBreakStatement(breakStatement, definiteAssignment);
        } else if (statement2 instanceof PsiContinueStatement) {
            PsiContinueStatement continueStatement = (PsiContinueStatement)statement2;
            DefiniteAssignmentUtil.checkContinueStatement(continueStatement, definiteAssignment);
        } else if (statement2 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            DefiniteAssignmentUtil.checkDeclarationStatement(declarationStatement, definiteAssignment);
        } else if (statement2 instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement2;
            DefiniteAssignmentUtil.checkDoWhileStatement(doWhileStatement, definiteAssignment);
        } else if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            DefiniteAssignmentUtil.checkExpression(expressionStatement.getExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        } else if (statement2 instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)statement2;
            DefiniteAssignmentUtil.checkExpressionListStatement(expressionListStatement, definiteAssignment);
        } else if (statement2 instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement2;
            DefiniteAssignmentUtil.checkForeachStatement(foreachStatement, definiteAssignment);
        } else if (statement2 instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement2;
            DefiniteAssignmentUtil.checkForStatement(forStatement, definiteAssignment);
        } else if (statement2 instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            DefiniteAssignmentUtil.checkIfStatement(ifStatement, definiteAssignment);
        } else if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            DefiniteAssignmentUtil.checkLabeledStatement(labeledStatement, definiteAssignment);
        } else if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            DefiniteAssignmentUtil.checkReturnStatement(returnStatement, definiteAssignment);
        } else if (statement2 instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement2;
            DefiniteAssignmentUtil.checkSwitchStatement(switchStatement, definiteAssignment);
        } else if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            DefiniteAssignmentUtil.checkSynchronizedStatement(synchronizedStatement, definiteAssignment);
        } else if (statement2 instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement2;
            DefiniteAssignmentUtil.checkThrowStatement(throwStatement, definiteAssignment);
        } else if (statement2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement2;
            DefiniteAssignmentUtil.checkTryStatement(tryStatement, definiteAssignment);
        } else if (statement2 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement2;
            DefiniteAssignmentUtil.checkWhileStatement(whileStatement, definiteAssignment);
        }
    }

    private static void checkAssertStatement(PsiAssertStatement assertStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition2 = assertStatement.getAssertCondition();
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        boolean resultDu = du && definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(da, du);
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        DefiniteAssignmentUtil.checkExpression(assertStatement.getAssertDescription(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        definiteAssignment.set(da, resultDu);
    }

    private static void checkBreakStatement(PsiBreakStatement breakStatement, DefiniteAssignment definiteAssignment) {
        definiteAssignment.storeBeforeBreakStatement(breakStatement);
        definiteAssignment.set(true, true);
    }

    private static void checkContinueStatement(PsiContinueStatement continueStatement, DefiniteAssignment definiteAssignment) {
        definiteAssignment.storeBeforeContinueStatement(continueStatement);
        definiteAssignment.set(true, true);
    }

    private static void checkDeclarationStatement(PsiDeclarationStatement declarationStatement, DefiniteAssignment definiteAssignment) {
        for (PsiElement element : declarationStatement.getDeclaredElements()) {
            if (element instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)element;
                DefiniteAssignmentUtil.checkLocalVariable(variable, definiteAssignment);
                continue;
            }
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                boolean da = definiteAssignment.isDefinitelyAssigned();
                boolean du = definiteAssignment.isDefinitelyUnassigned();
                definiteAssignment.set(true, false);
                DefiniteAssignmentUtil.checkClass(aClass, definiteAssignment);
                definiteAssignment.set(da, du);
                continue;
            }
            throw new AssertionError((Object)("unknown element declared: " + element));
        }
    }

    private static void checkDoWhileStatement(PsiDoWhileStatement doWhileStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition2 = doWhileStatement.getCondition();
        PsiStatement body2 = doWhileStatement.getBody();
        DefiniteAssignmentUtil.checkStatement(body2, definiteAssignment);
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned() & du);
        DefiniteAssignmentUtil.checkStatement(body2, definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeContinue((PsiStatement)doWhileStatement);
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        definiteAssignment.andDefiniteAssignmentBeforeBreak((PsiStatement)doWhileStatement);
    }

    private static void checkExpressionListStatement(PsiExpressionListStatement expressionListStatement, DefiniteAssignment definiteAssignment) {
        PsiExpressionList expressionList = expressionListStatement.getExpressionList();
        for (PsiExpression expression2 : expressionList.getExpressions()) {
            DefiniteAssignmentUtil.checkExpression(expression2, definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
    }

    private static void checkForeachStatement(PsiForeachStatement foreachStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(foreachStatement.getIteratedValue(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        boolean da = definiteAssignment.isDefinitelyAssigned();
        DefiniteAssignmentUtil.checkStatement(foreachStatement.getBody(), definiteAssignment);
        definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned());
        definiteAssignment.andDefiniteAssignmentBeforeBreak((PsiStatement)foreachStatement);
    }

    private static void checkForStatement(PsiForStatement forStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkStatement(forStatement.getInitialization(), definiteAssignment);
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition2 = forStatement.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkStatement(forStatement.getBody(), definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeContinue((PsiStatement)forStatement);
        DefiniteAssignmentUtil.checkStatement(forStatement.getUpdate(), definiteAssignment);
        DefiniteAssignmentUtil.checkStatement(forStatement.getBody(), definiteAssignment);
        definiteAssignment.set(da, du);
        if (condition2 == null) {
            definiteAssignment.set(true, true);
        } else {
            DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        }
        definiteAssignment.andDefiniteAssignmentBeforeBreak((PsiStatement)forStatement);
    }

    private static void checkIfStatement(PsiIfStatement ifStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition2 = ifStatement.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkStatement(ifStatement.getThenBranch(), definiteAssignment);
        boolean resultDa = definiteAssignment.isDefinitelyAssigned();
        boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(da, du);
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        DefiniteAssignmentUtil.checkStatement(ifStatement.getElseBranch(), definiteAssignment);
        definiteAssignment.and(resultDa, resultDu);
    }

    private static void checkLabeledStatement(PsiLabeledStatement labeledStatement, DefiniteAssignment definiteAssignment) {
        PsiStatement statement2 = labeledStatement.getStatement();
        DefiniteAssignmentUtil.checkStatement(statement2, definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeBreak(statement2);
    }

    private static void checkReturnStatement(PsiReturnStatement returnStatement, DefiniteAssignment definiteAssignment) {
        definiteAssignment.storeBeforeReturn(returnStatement);
        DefiniteAssignmentUtil.checkExpression(returnStatement.getReturnValue(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        definiteAssignment.set(true, true);
    }

    private static void checkSwitchStatement(PsiSwitchStatement switchStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(switchStatement.getExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return;
        }
        boolean defaultSeen = false;
        for (PsiStatement statement2 : statements) {
            PsiSwitchLabelStatement switchLabelStatement;
            if (statement2 instanceof PsiSwitchLabelStatement && (switchLabelStatement = (PsiSwitchLabelStatement)statement2).isDefaultCase()) {
                defaultSeen = true;
            }
            DefiniteAssignmentUtil.checkStatement(statement2, definiteAssignment);
        }
        definiteAssignment.andDefiniteAssignmentBeforeBreak((PsiStatement)switchStatement);
        definiteAssignment.and(defaultSeen, definiteAssignment.isDefinitelyUnassigned());
    }

    private static void checkSynchronizedStatement(PsiSynchronizedStatement synchronizedStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(synchronizedStatement.getLockExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        DefiniteAssignmentUtil.checkCodeBlock(synchronizedStatement.getBody(), definiteAssignment);
    }

    private static void checkThrowStatement(PsiThrowStatement throwStatement, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(throwStatement.getException(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        definiteAssignment.set(true, true);
    }

    private static void checkTryStatement(PsiTryStatement tryStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement element : resourceList) {
                if (element instanceof PsiResourceExpression) {
                    PsiResourceExpression resourceExpression = (PsiResourceExpression)element;
                    DefiniteAssignmentUtil.checkExpression(resourceExpression.getExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
                    continue;
                }
                if (element instanceof PsiResourceVariable) {
                    PsiResourceVariable resourceVariable = (PsiResourceVariable)element;
                    DefiniteAssignmentUtil.checkExpression(resourceVariable.getInitializer(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
                    continue;
                }
                throw new AssertionError();
            }
        }
        DefiniteAssignmentUtil.checkCodeBlock(tryStatement.getTryBlock(), definiteAssignment);
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        boolean resultDa = definiteAssignment.isDefinitelyAssigned();
        boolean resultDu = du;
        for (PsiCodeBlock catchBlock : tryStatement.getCatchBlocks()) {
            definiteAssignment.set(da, du);
            DefiniteAssignmentUtil.checkCodeBlock(catchBlock, definiteAssignment);
            resultDu &= definiteAssignment.isDefinitelyUnassigned();
            resultDa &= definiteAssignment.isDefinitelyAssigned();
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned());
            DefiniteAssignmentUtil.checkCodeBlock(finallyBlock, definiteAssignment);
            resultDu &= definiteAssignment.isDefinitelyUnassigned();
        }
        definiteAssignment.set(resultDa | definiteAssignment.isDefinitelyAssigned(), resultDu);
    }

    private static void checkWhileStatement(PsiWhileStatement whileStatement, DefiniteAssignment definiteAssignment) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        PsiExpression condition2 = whileStatement.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkStatement(whileStatement.getBody(), definiteAssignment);
        definiteAssignment.andDefiniteAssignmentBeforeContinue((PsiStatement)whileStatement);
        definiteAssignment.set(da, definiteAssignment.isDefinitelyUnassigned());
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        definiteAssignment.andDefiniteAssignmentBeforeBreak((PsiStatement)whileStatement);
    }

    private static void checkExpression(@Nullable PsiExpression expression2, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        Object result2;
        if (expression2 == null || definiteAssignment.stop()) {
            return;
        }
        if (PsiType.BOOLEAN.equals((Object)expression2.getType()) && (result2 = ExpressionUtils.computeConstantExpression(expression2)) != null) {
            if (Boolean.TRUE == result2 && BooleanExpressionValue.WHEN_FALSE == value2 || Boolean.FALSE == result2 && BooleanExpressionValue.WHEN_TRUE == value2) {
                definiteAssignment.set(true, true);
            }
            return;
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            DefiniteAssignmentUtil.checkArrayAccessExpression(arrayAccessExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression2;
            DefiniteAssignmentUtil.checkArrayInitializerExpression(arrayInitializerExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            DefiniteAssignmentUtil.checkAssignmentExpression(assignmentExpression, definiteAssignment);
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            DefiniteAssignmentUtil.checkConditionalExpression(conditionalExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            DefiniteAssignmentUtil.checkExpression(instanceOfExpression.getOperand(), definiteAssignment, value2);
        } else if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)expression2;
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), false);
            DefiniteAssignmentUtil.checkLambdaExpression(lambdaExpression, definiteAssignment);
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), du);
        } else if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            DefiniteAssignmentUtil.checkMethodCallExpression(methodCallExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            DefiniteAssignmentUtil.checkNewExpression(newExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            DefiniteAssignmentUtil.checkExpression(parenthesizedExpression.getExpression(), definiteAssignment, value2);
        } else if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            DefiniteAssignmentUtil.checkPolyadicExpression(polyadicExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression2;
            DefiniteAssignmentUtil.checkPostFixExpression(postfixExpression, definiteAssignment);
        } else if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            DefiniteAssignmentUtil.checkPrefixExpression(prefixExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            DefiniteAssignmentUtil.checkReferenceExpression(referenceExpression, definiteAssignment, value2);
        } else if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            DefiniteAssignmentUtil.checkExpression(typeCastExpression.getOperand(), definiteAssignment, value2);
        }
    }

    private static void checkArrayAccessExpression(PsiArrayAccessExpression arrayAccessExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        DefiniteAssignmentUtil.checkExpression(arrayAccessExpression.getArrayExpression(), definiteAssignment, value2);
        DefiniteAssignmentUtil.checkExpression(arrayAccessExpression.getIndexExpression(), definiteAssignment, value2);
    }

    private static void checkArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializerExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
            DefiniteAssignmentUtil.checkExpression(initializer, definiteAssignment, value2);
        }
    }

    private static void checkAssignmentExpression(PsiAssignmentExpression assignmentExpression, DefiniteAssignment definiteAssignment) {
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiReferenceExpression referenceExpression = DefiniteAssignmentUtil.getReferenceIfAssignmentOfVariable(lhs, definiteAssignment);
        if (referenceExpression == null) {
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, BooleanExpressionValue.UNDEFINED);
            DefiniteAssignmentUtil.checkExpression(assignmentExpression.getRExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        } else {
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                definiteAssignment.valueAccess(referenceExpression);
            }
            DefiniteAssignmentUtil.checkExpression(assignmentExpression.getRExpression(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
            definiteAssignment.assign(referenceExpression, true);
        }
    }

    private static PsiReferenceExpression getReferenceIfAssignmentOfVariable(PsiExpression lhs, DefiniteAssignment definiteAssignment) {
        if (!((lhs = ParenthesesUtils.stripParentheses(lhs)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
        PsiElement target = referenceExpression.resolve();
        if (!definiteAssignment.getVariable().equals(target)) {
            return null;
        }
        PsiExpression qualifier = referenceExpression.getQualifierExpression();
        if (!(qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null)) {
            return null;
        }
        return referenceExpression;
    }

    private static void checkConditionalExpression(PsiConditionalExpression conditionalExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
        PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
        if (thenExpression2 != null && PsiType.BOOLEAN.equals((Object)thenExpression2.getType()) && elseExpression2 != null && PsiType.BOOLEAN.equals((Object)elseExpression2.getType())) {
            if (value2 == BooleanExpressionValue.WHEN_TRUE) {
                DefiniteAssignmentUtil.checkConditionalInternal(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
            } else if (value2 == BooleanExpressionValue.WHEN_FALSE) {
                DefiniteAssignmentUtil.checkConditionalInternal(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
            } else {
                boolean da = definiteAssignment.isDefinitelyAssigned();
                boolean du = definiteAssignment.isDefinitelyUnassigned();
                DefiniteAssignmentUtil.checkConditionalExpression(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
                boolean resultDa = definiteAssignment.isDefinitelyAssigned();
                boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
                definiteAssignment.set(da, du);
                DefiniteAssignmentUtil.checkConditionalExpression(conditionalExpression, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
                definiteAssignment.and(resultDa, resultDu);
            }
        } else {
            DefiniteAssignmentUtil.checkConditionalInternal(conditionalExpression, definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
    }

    private static void checkConditionalInternal(PsiConditionalExpression conditionalExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        boolean da = definiteAssignment.isDefinitelyAssigned();
        boolean du = definiteAssignment.isDefinitelyUnassigned();
        PsiExpression condition2 = conditionalExpression.getCondition();
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
        DefiniteAssignmentUtil.checkExpression(conditionalExpression.getThenExpression(), definiteAssignment, value2);
        boolean resultDa = definiteAssignment.isDefinitelyAssigned();
        boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
        definiteAssignment.set(da, du);
        DefiniteAssignmentUtil.checkExpression(condition2, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
        DefiniteAssignmentUtil.checkExpression(conditionalExpression.getElseExpression(), definiteAssignment, value2);
        definiteAssignment.and(resultDa, resultDu);
    }

    private static void checkLambdaExpression(PsiLambdaExpression lambdaExpression, DefiniteAssignment definiteAssignment) {
        PsiElement body2 = lambdaExpression.getBody();
        if (body2 instanceof PsiExpression) {
            PsiExpression bodyExpression = (PsiExpression)body2;
            DefiniteAssignmentUtil.checkExpression(bodyExpression, definiteAssignment, BooleanExpressionValue.UNDEFINED);
        } else if (body2 instanceof PsiCodeBlock) {
            PsiCodeBlock codeBlock = (PsiCodeBlock)body2;
            DefiniteAssignmentUtil.checkCodeBlock(codeBlock, definiteAssignment);
        }
    }

    private static void checkMethodCallExpression(PsiMethodCallExpression methodCallExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        DefiniteAssignmentUtil.checkExpression(qualifier, definiteAssignment, value2);
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression argument : argumentList.getExpressions()) {
            DefiniteAssignmentUtil.checkExpression(argument, definiteAssignment, value2);
        }
    }

    private static void checkNewExpression(PsiNewExpression newExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        PsiAnonymousClass anonymousClass;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            for (PsiExpression argument : argumentList.getExpressions()) {
                DefiniteAssignmentUtil.checkExpression(argument, definiteAssignment, value2);
            }
        }
        if ((anonymousClass = newExpression.getAnonymousClass()) != null) {
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), false);
            DefiniteAssignmentUtil.checkAnonymousClass(anonymousClass, definiteAssignment);
            definiteAssignment.set(definiteAssignment.isDefinitelyAssigned(), du);
        }
        for (PsiExpression dimension : newExpression.getArrayDimensions()) {
            DefiniteAssignmentUtil.checkExpression(dimension, definiteAssignment, value2);
        }
        PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
        if (arrayInitializer != null) {
            DefiniteAssignmentUtil.checkExpression((PsiExpression)arrayInitializer, definiteAssignment, value2);
        }
    }

    private static void checkPolyadicExpression(PsiPolyadicExpression polyadicExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (JavaTokenType.OROR == tokenType || JavaTokenType.ANDAND == tokenType) {
            for (int i2 = 1; i2 < operands2.length; ++i2) {
                DefiniteAssignmentUtil.checkBinaryExpression(operands2[i2 - 1], operands2[i2], tokenType == JavaTokenType.ANDAND, definiteAssignment, value2);
            }
        } else {
            for (PsiExpression operand2 : operands2) {
                DefiniteAssignmentUtil.checkExpression(operand2, definiteAssignment, BooleanExpressionValue.UNDEFINED);
            }
        }
    }

    private static void checkBinaryExpression(PsiExpression lhs, PsiExpression rhs, boolean and, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        if (and ? value2 == BooleanExpressionValue.WHEN_FALSE : value2 == BooleanExpressionValue.WHEN_TRUE) {
            boolean da = definiteAssignment.isDefinitelyAssigned();
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_FALSE : BooleanExpressionValue.WHEN_TRUE);
            boolean resultDa = definiteAssignment.isDefinitelyAssigned();
            boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(da, du);
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_TRUE : BooleanExpressionValue.WHEN_FALSE);
            DefiniteAssignmentUtil.checkExpression(rhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_FALSE : BooleanExpressionValue.WHEN_TRUE);
            definiteAssignment.and(resultDa, resultDu);
        } else if (and ? value2 == BooleanExpressionValue.WHEN_TRUE : value2 == BooleanExpressionValue.WHEN_FALSE) {
            DefiniteAssignmentUtil.checkExpression(lhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_TRUE : BooleanExpressionValue.WHEN_FALSE);
            DefiniteAssignmentUtil.checkExpression(rhs, definiteAssignment, and ? BooleanExpressionValue.WHEN_TRUE : BooleanExpressionValue.WHEN_FALSE);
        } else {
            boolean da = definiteAssignment.isDefinitelyAssigned();
            boolean du = definiteAssignment.isDefinitelyUnassigned();
            DefiniteAssignmentUtil.checkBinaryExpression(lhs, rhs, false, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
            boolean resultDa = definiteAssignment.isDefinitelyAssigned();
            boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
            definiteAssignment.set(da, du);
            DefiniteAssignmentUtil.checkBinaryExpression(lhs, rhs, false, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
            definiteAssignment.and(resultDa, resultDu);
        }
    }

    private static void checkPostFixExpression(PsiPostfixExpression postfixExpression, DefiniteAssignment definiteAssignment) {
        DefiniteAssignmentUtil.checkExpression(postfixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
    }

    private static void checkPrefixExpression(PsiPrefixExpression prefixExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (JavaTokenType.EXCL == tokenType) {
            if (value2 == BooleanExpressionValue.WHEN_TRUE) {
                DefiniteAssignmentUtil.checkExpression(prefixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
            } else if (value2 == BooleanExpressionValue.WHEN_FALSE) {
                DefiniteAssignmentUtil.checkExpression(prefixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
            } else {
                boolean da = definiteAssignment.isDefinitelyAssigned();
                boolean du = definiteAssignment.isDefinitelyUnassigned();
                DefiniteAssignmentUtil.checkPrefixExpression(prefixExpression, definiteAssignment, BooleanExpressionValue.WHEN_TRUE);
                boolean resultDa = definiteAssignment.isDefinitelyAssigned();
                boolean resultDu = definiteAssignment.isDefinitelyUnassigned();
                definiteAssignment.set(da, du);
                DefiniteAssignmentUtil.checkPrefixExpression(prefixExpression, definiteAssignment, BooleanExpressionValue.WHEN_FALSE);
                definiteAssignment.and(resultDa, resultDu);
            }
        } else {
            DefiniteAssignmentUtil.checkExpression(prefixExpression.getOperand(), definiteAssignment, BooleanExpressionValue.UNDEFINED);
        }
    }

    private static void checkReferenceExpression(PsiReferenceExpression referenceExpression, DefiniteAssignment definiteAssignment, BooleanExpressionValue value2) {
        PsiExpression qualifier = referenceExpression.getQualifierExpression();
        if (qualifier != null) {
            DefiniteAssignmentUtil.checkExpression(qualifier, definiteAssignment, value2);
        }
        if (!definiteAssignment.getVariable().equals(referenceExpression.resolve())) {
            return;
        }
        if (PsiUtil.isAccessedForWriting((PsiExpression)referenceExpression)) {
            definiteAssignment.assign(referenceExpression, false);
        } else {
            if (qualifier != null) {
                if (!(qualifier instanceof PsiThisExpression)) {
                    return;
                }
                PsiThisExpression thisExpression = (PsiThisExpression)qualifier;
                if (thisExpression.getQualifier() != null) {
                    return;
                }
            }
            definiteAssignment.valueAccess(referenceExpression);
        }
    }

    private static enum BooleanExpressionValue {
        WHEN_TRUE,
        WHEN_FALSE,
        UNDEFINED;

    }
}

