/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.DefiniteAssignment;
import com.siyeh.ig.psiutils.DefiniteAssignmentUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import org.jetbrains.annotations.NotNull;

public class FinalUtils {
    private FinalUtils() {
    }

    public static boolean canBeFinal(@NotNull PsiVariable variable) {
        if (variable.getInitializer() != null || variable instanceof PsiParameter) {
            return !VariableAccessUtils.variableIsAssigned(variable);
        }
        FinalDefiniteAssignment definiteAssignment = new FinalDefiniteAssignment(variable);
        DefiniteAssignmentUtil.checkVariable(variable, definiteAssignment);
        return definiteAssignment.isDefinitelyAssigned() && !definiteAssignment.isDefinitelyUnassigned() && definiteAssignment.canBeFinal() && !FinalUtils.isWrittenToOutsideOfConstruction(variable);
    }

    private static boolean isWrittenToOutsideOfConstruction(PsiVariable variable) {
        if (!(variable instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)variable;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)variable);
        VariableAssignedVisitor visitor = new VariableAssignedVisitor((PsiVariable)field);
        if (topLevelClass != null && !containingClass.equals(topLevelClass)) {
            visitor.setExcludedElement((PsiElement)containingClass);
            topLevelClass.accept((PsiElementVisitor)visitor);
            if (visitor.isAssigned()) {
                return true;
            }
        }
        if (field.hasModifierProperty("static")) {
            for (PsiElement child : containingClass.getChildren()) {
                if (child instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)child;
                    if (classInitializer.hasModifierProperty("static")) continue;
                    classInitializer.accept((PsiElementVisitor)visitor);
                } else if (child instanceof PsiField) {
                    PsiField otherField = (PsiField)child;
                    if (otherField.hasModifierProperty("static")) continue;
                    otherField.accept((PsiElementVisitor)visitor);
                } else if (child instanceof PsiMethod || child instanceof PsiClass) {
                    child.accept((PsiElementVisitor)visitor);
                }
                if (!visitor.isAssigned()) continue;
                return true;
            }
        } else {
            for (PsiElement child : containingClass.getChildren()) {
                if (child instanceof PsiField) {
                    PsiField otherField = (PsiField)child;
                    if (!otherField.hasModifierProperty("static")) continue;
                    otherField.accept((PsiElementVisitor)visitor);
                } else if (child instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)child;
                    if (!classInitializer.hasModifierProperty("static")) continue;
                    classInitializer.accept((PsiElementVisitor)visitor);
                } else if (child instanceof PsiMethod) {
                    PsiMethod method2 = (PsiMethod)child;
                    if (method2.isConstructor()) continue;
                    method2.accept((PsiElementVisitor)visitor);
                } else if (child instanceof PsiClass) {
                    child.accept((PsiElementVisitor)visitor);
                }
                if (!visitor.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    private static class FinalDefiniteAssignment
    extends DefiniteAssignment {
        private boolean canBeFinal = true;

        public FinalDefiniteAssignment(PsiVariable variable) {
            super(variable);
        }

        @Override
        public void assign(@NotNull PsiReferenceExpression expression2, boolean definiteAssignment) {
            if (!this.isDefinitelyUnassigned()) {
                this.canBeFinal = false;
            }
            super.assign(expression2, definiteAssignment);
        }

        @Override
        public void valueAccess(PsiReferenceExpression expression2) {
            if (!this.isDefinitelyAssigned()) {
                this.canBeFinal = false;
            }
            super.valueAccess(expression2);
        }

        @Override
        public boolean stop() {
            return !this.canBeFinal;
        }

        public boolean canBeFinal() {
            return this.canBeFinal;
        }
    }
}

