/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class HighlightUtils {
    private HighlightUtils() {
    }

    public static void highlightElement(@NotNull PsiElement element) {
        HighlightUtils.highlightElements(Collections.singleton(element));
    }

    public static void highlightElements(@NotNull Collection<? extends PsiElement> elementCollection) {
        if (elementCollection.isEmpty()) {
            return;
        }
        if (elementCollection.contains(null)) {
            throw new IllegalArgumentException("Nulls passed in collection: " + elementCollection);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Object[] elements = PsiUtilCore.toPsiElementArray((Collection)elementCollection);
            PsiElement firstElement = elements[0];
            if (ContainerUtil.exists((Object[])elements, element -> !element.isValid())) {
                return;
            }
            Project project2 = firstElement.getProject();
            if (project2.isDisposed()) {
                return;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project2);
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Editor editor = editorManager.getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            EditorColorsScheme globalScheme = editorColorsManager.getGlobalScheme();
            TextAttributes textattributes = globalScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])elements, textattributes, true, null);
            WindowManager windowManager = WindowManager.getInstance();
            StatusBar statusBar = windowManager.getStatusBar(project2);
            statusBar.setInfo(InspectionGadgetsBundle.message("press.escape.to.remove.highlighting.message", new Object[0]));
            FindManager findmanager = FindManager.getInstance((Project)project2);
            FindModel findmodel = findmanager.getFindNextModel();
            if (findmodel == null) {
                findmodel = findmanager.getFindInFileModel();
            }
            findmodel.setSearchHighlighters(true);
            findmanager.setFindWasPerformed();
            findmanager.setFindNextModel(findmodel);
        });
    }

    public static void showRenameTemplate(PsiElement context, PsiNameIdentifierOwner element, PsiReference ... references) {
        Project project2 = (context = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(context)).getProject();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl(context);
        MacroCallNode macroCallNode = new MacroCallNode(new SuggestVariableNameMacro());
        PsiElement identifier = element.getNameIdentifier();
        builder.replaceElement(identifier, "PATTERN", (Expression)macroCallNode, true);
        for (PsiReference reference : references) {
            builder.replaceElement(reference, "PATTERN", "PATTERN", false);
        }
        Template template = builder.buildInlineTemplate();
        TextRange textRange = context.getTextRange();
        int startOffset = textRange.getStartOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        TemplateManager templateManager = TemplateManager.getInstance(project2);
        templateManager.startTemplate(editor, template);
    }
}

