/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isTypeInLibrary(@Nullable PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiClass aClass = classType.resolve();
        return LibraryUtil.classIsInLibrary(aClass);
    }

    public static boolean classIsInLibrary(@Nullable PsiClass aClass) {
        return aClass instanceof PsiCompiledElement;
    }

    public static boolean callOnLibraryMethod(@NotNull PsiMethodCallExpression expression2) {
        PsiMethod method2 = expression2.resolveMethod();
        return method2 instanceof PsiCompiledElement;
    }

    public static boolean isOverrideOfLibraryMethod(@NotNull PsiMethod method2) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method2.findSuperMethods()) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (LibraryUtil.classIsInLibrary(containingClass)) {
                return true;
            }
            if (!LibraryUtil.isOverrideOfLibraryMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverrideOfLibraryMethodParameter(@Nullable PsiVariable variable) {
        if (!(variable instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter = (PsiParameter)variable;
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)scope;
        return LibraryUtil.isOverrideOfLibraryMethod(method2);
    }

    public static boolean isOnlyLibraryCodeUsed(PsiElement element) {
        if (element == null) {
            return false;
        }
        final Ref libraryCode = Ref.create((Object)Boolean.TRUE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (!((Boolean)libraryCode.get()).booleanValue()) {
                    return;
                }
                super.visitReferenceExpression(expression2);
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiCompiledElement)) {
                    libraryCode.set((Object)Boolean.FALSE);
                }
            }
        });
        return (Boolean)libraryCode.get();
    }
}

