/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallUtils {
    @NonNls
    private static final Set<String> regexMethodNames = new HashSet<String>(5);

    private MethodCallUtils() {
    }

    @Nullable
    public static String getMethodName(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression method2 = expression2.getMethodExpression();
        return method2.getReferenceName();
    }

    @Nullable
    public static PsiType getTargetType(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        if (qualifierExpression2 == null) {
            return null;
        }
        return qualifierExpression2.getType();
    }

    public static boolean isCompareToCall(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        if (!"compareTo".equals(methodExpression.getReferenceName())) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        return MethodUtils.isCompareTo(method2);
    }

    public static boolean isCompareToIgnoreCaseCall(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        if (!"compareToIgnoreCase".equals(methodExpression.getReferenceName())) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        return MethodUtils.isCompareToIgnoreCase(method2);
    }

    public static boolean isEqualsCall(PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!"equals".equals(name)) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        return MethodUtils.isEquals(method2);
    }

    public static boolean isEqualsIgnoreCaseCall(PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!"equalsIgnoreCase".equals(name)) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        return MethodUtils.isEqualsIgnoreCase(method2);
    }

    public static boolean isSimpleCallToMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (parameterTypeStrings == null) {
            return MethodCallUtils.isCallToMethod(expression2, calledOnClassName, returnType, methodName, (PsiType[])null);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)expression2.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
        GlobalSearchScope scope = expression2.getResolveScope();
        for (int i2 = 0; i2 < parameterTypeStrings.length; ++i2) {
            String parameterTypeString = parameterTypeStrings[i2];
            parameterTypes[i2] = factory.createTypeByFQClassName(parameterTypeString, scope);
        }
        return MethodCallUtils.isCallToMethod(expression2, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToStaticMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @NotNull String calledOnClassName, @NonNls @NotNull String methodName, int parameterCount) {
        PsiExpression[] args = expression2.getArgumentList().getExpressions();
        if (!methodName.equals(MethodCallUtils.getMethodName(expression2)) || args.length < parameterCount) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null || !method2.hasModifierProperty("static") || method2.getParameterList().getParametersCount() != parameterCount || !method2.isVarArgs() && args.length != parameterCount) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        return aClass != null && calledOnClassName.equals(aClass.getQualifiedName());
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        PsiExpression qualifier;
        PsiMethod method2;
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        if (methodNamePattern != null) {
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return false;
            }
            Matcher matcher = methodNamePattern.matcher(referenceName);
            if (!matcher.matches()) {
                return false;
            }
        }
        if ((method2 = expression2.resolveMethod()) == null) {
            return false;
        }
        if (calledOnClassName != null && (qualifier = methodExpression.getQualifierExpression()) != null) {
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, calledOnClassName)) {
                return false;
            }
            return MethodUtils.methodMatches(method2, null, returnType, methodNamePattern, parameterTypes);
        }
        return MethodUtils.methodMatches(method2, calledOnClassName, returnType, methodNamePattern, parameterTypes);
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        String referenceName;
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        if (methodName != null && !methodName.equals(referenceName = methodExpression.getReferenceName())) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null) {
            return false;
        }
        return MethodUtils.methodMatches(method2, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToRegexMethod(PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!regexMethodNames.contains(name)) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className = containingClass.getQualifiedName();
        return "java.lang.String".equals(className) || "java.util.regex.Pattern".equals(className);
    }

    public static boolean isCallDuringObjectConstruction(PsiMethodCallExpression expression2) {
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (member == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null || containingClass.hasModifierProperty("final")) {
            return false;
        }
        if (member instanceof PsiClassInitializer) {
            PsiClassInitializer classInitializer = (PsiClassInitializer)member;
            if (!classInitializer.hasModifierProperty("static")) {
                return true;
            }
        } else {
            PsiField field;
            if (member instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)member;
                if (method2.isConstructor()) {
                    return true;
                }
                if (CloneUtils.isClone(method2)) {
                    return true;
                }
                if (MethodUtils.simpleMethodMatches(method2, null, "void", "readObject", "java.io.ObjectInputStream")) {
                    return true;
                }
                return MethodUtils.simpleMethodMatches(method2, null, "void", "readObjectNoData", new String[0]);
            }
            if (member instanceof PsiField && !(field = (PsiField)member).hasModifierProperty("static")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodCallOnVariable(@NotNull PsiMethodCallExpression expression2, @NotNull PsiVariable variable, @NotNull String methodName) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!methodName.equals(name)) {
            return false;
        }
        PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement element = referenceExpression.resolve();
        return variable.equals(element);
    }

    @Nullable
    public static PsiMethod findMethodWithReplacedArgument(@NotNull PsiCall call, @NotNull PsiExpression target, @NotNull PsiExpression replacement) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] expressions2 = argumentList.getExpressions();
        int index = -1;
        for (int i2 = 0; i2 < expressions2.length; ++i2) {
            PsiExpression expression2 = expressions2[i2];
            if (expression2 != target) continue;
            index = i2;
        }
        if (index < 0) {
            return null;
        }
        PsiCall copy = (PsiCall)call.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        assert (copyArgumentList != null);
        PsiExpression[] arguments = copyArgumentList.getExpressions();
        arguments[index].replace((PsiElement)replacement);
        if (call instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call).getContainingClass();
            assert (containingClass != null);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)call.getProject());
            PsiClassType type2 = facade.getElementFactory().createType(containingClass);
            JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(type2, copy.getArgumentList(), (PsiElement)call);
            return (PsiMethod)resolveResult.getElement();
        }
        return copy.resolveMethod();
    }

    public static boolean isNecessaryForSurroundingMethodCall(PsiExpression expression2, PsiExpression replacement) {
        PsiElement parent = expression2.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            expression2 = (PsiExpression)parent;
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiCall)) {
            return false;
        }
        PsiCall call = (PsiCall)grandParent;
        return call.resolveMethod() != MethodCallUtils.findMethodWithReplacedArgument(call, expression2, replacement);
    }

    public static boolean isSuperMethodCall(@NotNull PsiMethodCallExpression expression2, @NotNull PsiMethod method2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression target = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (!(target instanceof PsiSuperExpression)) {
            return false;
        }
        PsiMethod targetMethod = expression2.resolveMethod();
        return targetMethod != null && MethodSignatureUtil.isSuperMethod((PsiMethod)targetMethod, (PsiMethod)method2);
    }

    public static boolean isVarArgCall(PsiMethodCallExpression call) {
        JavaResolveResult result2 = call.resolveMethodGenerics();
        PsiMethod method2 = (PsiMethod)ObjectUtils.tryCast((Object)result2.getElement(), PsiMethod.class);
        if (method2 == null || !method2.isVarArgs()) {
            return false;
        }
        PsiSubstitutor substitutor = result2.getSubstitutor();
        return MethodCallInstruction.isVarArgCall(method2, substitutor, call.getArgumentList().getExpressions(), method2.getParameterList().getParameters());
    }

    public static boolean containsSuperMethodCall(@NotNull PsiMethod method2) {
        SuperCallVisitor visitor = new SuperCallVisitor(method2);
        method2.accept((PsiElementVisitor)visitor);
        return visitor.isSuperCallFound();
    }

    public static boolean callWithNonConstantString(@NotNull PsiMethodCallExpression expression2, boolean considerStaticFinalConstant, String className, String ... methodNames) {
        PsiField field;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        boolean found = false;
        for (String name : methodNames) {
            if (!name.equals(methodName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)className)) {
            return false;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression argument = ParenthesesUtils.stripParentheses(ExpressionUtils.getFirstExpressionInList(argumentList));
        if (argument == null) {
            return false;
        }
        PsiType type2 = argument.getType();
        if (type2 == null || !type2.equalsToText("java.lang.String")) {
            return false;
        }
        if (considerStaticFinalConstant && argument instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiField && (field = (PsiField)target).hasModifierProperty("static") && field.hasModifierProperty("final")) {
            return false;
        }
        return !PsiUtil.isConstantExpression((PsiExpression)argument);
    }

    @Nullable
    public static PsiMethodCallExpression getQualifierMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)methodCall.getMethodExpression().getQualifierExpression()), PsiMethodCallExpression.class);
    }

    static {
        regexMethodNames.add("compile");
        regexMethodNames.add("matches");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMethod myMethod;
        private boolean mySuperCallFound;

        public SuperCallVisitor(@NotNull PsiMethod method2) {
            this.myMethod = method2;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (!this.mySuperCallFound) {
                super.visitElement(element);
            }
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            super.visitLambdaExpression(expression2);
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiExpression condition2 = statement2.getCondition();
            Object result2 = ExpressionUtils.computeConstantExpression(condition2);
            if (result2 != null && result2.equals(Boolean.FALSE)) {
                return;
            }
            super.visitIfStatement(statement2);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (this.mySuperCallFound) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (MethodCallUtils.isSuperMethodCall(expression2, this.myMethod)) {
                this.mySuperCallFound = true;
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement target;
            if (this.mySuperCallFound) {
                return;
            }
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression && (target = expression2.resolve()) instanceof PsiMethod && MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)target), (PsiMethod)this.myMethod)) {
                this.mySuperCallFound = true;
                return;
            }
            super.visitMethodReferenceExpression(expression2);
        }

        boolean isSuperCallFound() {
            return this.mySuperCallFound;
        }
    }
}

