/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.BaseInspection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodMatcher {
    private final List<String> myMethodNamePatterns = ContainerUtil.newArrayList();
    private final List<String> myClassNames = ContainerUtil.newArrayList();
    private final Map<String, Pattern> myPatternCache = ContainerUtil.newHashMap();
    private final boolean myWriteDefaults;
    private final String myOptionName;
    private String myDefaultSettings = null;

    public MethodMatcher() {
        this(false, "METHOD_MATCHER_CONFIG");
    }

    public MethodMatcher(boolean writeDefaults, String optionName) {
        this.myWriteDefaults = writeDefaults;
        this.myOptionName = optionName;
    }

    public MethodMatcher add(@NotNull String className, @NotNull String methodNamePattern) {
        this.myClassNames.add(className);
        this.myMethodNamePatterns.add(methodNamePattern);
        return this;
    }

    public void add(@NotNull PsiMethodCallExpression expression2) {
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 != null) {
            this.add(method2);
        }
    }

    public void add(@NotNull PsiMethod method2) {
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return;
        }
        String fqName = aClass.getQualifiedName();
        int index = this.myClassNames.indexOf(fqName);
        String methodName = method2.getName();
        if (index < 0) {
            this.myClassNames.add(fqName);
            this.myMethodNamePatterns.add(methodName);
        } else {
            String[] names;
            String pattern = this.myMethodNamePatterns.get(index);
            if (pattern.isEmpty()) {
                this.myMethodNamePatterns.set(index, methodName);
                return;
            }
            if (".*".equals(pattern)) {
                return;
            }
            for (String name : names = pattern.split("\\|")) {
                if (!methodName.equals(name)) continue;
                return;
            }
            this.myMethodNamePatterns.set(index, pattern + '|' + methodName);
        }
    }

    @NotNull
    protected String getOptionName() {
        return this.myOptionName;
    }

    public List<String> getMethodNamePatterns() {
        return this.myMethodNamePatterns;
    }

    public List<String> getClassNames() {
        return this.myClassNames;
    }

    public boolean matches(@Nullable PsiMethod method2) {
        if (method2 == null) {
            return false;
        }
        String methodName = method2.getName();
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        int size = this.myMethodNamePatterns.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String className;
            Pattern pattern = this.getPattern(i2);
            if (pattern == null || !pattern.matcher(methodName).matches() || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)(className = this.myClassNames.get(i2)))) continue;
            return true;
        }
        return false;
    }

    public boolean matches(PsiCall call) {
        return this.matches(call.resolveMethod());
    }

    private Pattern getPattern(int i2) {
        String methodNamePattern = this.myMethodNamePatterns.get(i2);
        Pattern pattern = this.myPatternCache.get(methodNamePattern);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(methodNamePattern);
                this.myPatternCache.put(methodNamePattern, pattern);
            }
            catch (NullPointerException | PatternSyntaxException ignore) {
                return null;
            }
        }
        return pattern;
    }

    public MethodMatcher finishDefault() {
        if (this.myDefaultSettings != null) {
            throw new IllegalStateException();
        }
        this.myDefaultSettings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        return this;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        String settings = null;
        for (Element option : node.getChildren("option")) {
            if (!option.getAttributeValue("name").equals(this.getOptionName())) continue;
            settings = option.getAttributeValue("value");
            break;
        }
        if (settings == null) {
            return;
        }
        this.myPatternCache.clear();
        this.myClassNames.clear();
        this.myMethodNamePatterns.clear();
        BaseInspection.parseString(settings, this.myClassNames, this.myMethodNamePatterns);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        String settings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        if (!this.myWriteDefaults && settings.equals(this.myDefaultSettings)) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", this.getOptionName()).setAttribute("value", settings));
    }
}

