/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class SideEffectChecker {
    private static final Set<String> ourSideEffectFreeClasses = new THashSet(Arrays.asList(Object.class.getName(), Short.class.getName(), Character.class.getName(), Byte.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), StringBuffer.class.getName(), Boolean.class.getName(), ArrayList.class.getName(), Date.class.getName(), HashMap.class.getName(), HashSet.class.getName(), Hashtable.class.getName(), LinkedHashMap.class.getName(), LinkedHashSet.class.getName(), LinkedList.class.getName(), Stack.class.getName(), TreeMap.class.getName(), TreeSet.class.getName(), Vector.class.getName(), WeakHashMap.class.getName()));

    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        exp.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    public static boolean mayHaveSideEffects(@NotNull PsiStatement statement2, Predicate<PsiMethodCallExpression> shouldIgnoreCall) {
        SideEffectsVisitor visitor = new SideEffectsVisitor(shouldIgnoreCall);
        statement2.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @NotNull List<PsiElement> sideEffects) {
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        element.accept((PsiElementVisitor)visitor);
        if (visitor.sideEffect != null) {
            sideEffects.add(visitor.sideEffect);
            return true;
        }
        return false;
    }

    private static boolean isSideEffectFreeConstructor(@NotNull PsiNewExpression newExpression) {
        PsiClass throwableClass;
        String packageName;
        String qualifiedName;
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        PsiClass aClass = classReference2 == null ? null : (PsiClass)classReference2.resolve();
        String string = qualifiedName = aClass == null ? null : aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (ourSideEffectFreeClasses.contains(qualifiedName)) {
            return true;
        }
        PsiFile file2 = aClass.getContainingFile();
        PsiDirectory directory = file2.getContainingDirectory();
        PsiPackage classPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
        String string2 = packageName = classPackage == null ? null : classPackage.getQualifiedName();
        return ("java.lang".equals(packageName) || "java.io".equals(packageName)) && (throwableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope())) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)throwableClass, (boolean)true);
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        PsiElement sideEffect;
        final Predicate<PsiMethodCallExpression> myIgnoredCallPredicate;

        SideEffectsVisitor() {
            this(call -> false);
        }

        SideEffectsVisitor(Predicate<PsiMethodCallExpression> predicate) {
            this.myIgnoredCallPredicate = predicate;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.sideEffect == null) {
                super.visitElement(element);
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitAssignmentExpression(expression2);
            this.sideEffect = expression2;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (this.myIgnoredCallPredicate.test(expression2)) {
                return;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (this.isPure(method2)) {
                return;
            }
            this.sideEffect = expression2;
        }

        protected boolean isPure(PsiMethod method2) {
            if (method2 == null) {
                return false;
            }
            if (PropertyUtil.isSimpleGetter((PsiMethod)method2)) {
                return true;
            }
            if (ControlFlowAnalyzer.isPure(method2)) {
                return ControlFlowAnalyzer.getMethodContracts(method2).stream().noneMatch(mc -> mc.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION);
            }
            return false;
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitNewExpression(expression2);
            this.sideEffect = SideEffectChecker.isSideEffectFreeConstructor(expression2) ? null : expression2;
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression2) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitPostfixExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.sideEffect = expression2;
            }
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
            if (this.sideEffect != null) {
                return;
            }
            super.visitPrefixExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.sideEffect = expression2;
            }
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            this.sideEffect = statement2;
            super.visitDeclarationStatement(statement2);
        }

        public void visitBreakStatement(PsiBreakStatement statement2) {
            this.sideEffect = statement2;
            super.visitBreakStatement(statement2);
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitContinueStatement(PsiContinueStatement statement2) {
            this.sideEffect = statement2;
            super.visitContinueStatement(statement2);
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            this.sideEffect = statement2;
            super.visitReturnStatement(statement2);
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            this.sideEffect = statement2;
            super.visitThrowStatement(statement2);
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public boolean mayHaveSideEffects() {
            return this.sideEffect != null;
        }
    }
}

