/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableAssignedFromVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean assignedFrom = false;
    @NotNull
    private final PsiVariable variable;

    public VariableAssignedFromVisitor(@NotNull PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (!this.assignedFrom) {
            super.visitElement(element);
        }
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (this.assignedFrom) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getRExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public void visitVariable(@NotNull PsiVariable var) {
        if (this.assignedFrom) {
            return;
        }
        super.visitVariable(var);
        PsiExpression initializer = var.getInitializer();
        if (VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public boolean isAssignedFrom() {
        return this.assignedFrom;
    }
}

