/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableReturnedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private final boolean myBuilderPattern;
    private boolean returned = false;

    public VariableReturnedVisitor(@NotNull PsiVariable variable, boolean builderPattern) {
        this.variable = variable;
        this.myBuilderPattern = builderPattern;
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (VariableAccessUtils.mayEvaluateToVariable(returnValue, this.variable, this.myBuilderPattern)) {
            this.returned = true;
            this.stopWalking();
            return;
        }
        super.visitReturnStatement(returnStatement);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        PsiElement body2 = expression2.getBody();
        if (body2 instanceof PsiExpression && VariableAccessUtils.mayEvaluateToVariable((PsiExpression)body2, this.variable, this.myBuilderPattern)) {
            this.returned = true;
            this.stopWalking();
            return;
        }
        super.visitLambdaExpression(expression2);
    }

    public boolean isReturned() {
        return this.returned;
    }
}

