/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class VariableUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean used;
    @NotNull
    private final PsiVariable variable;

    private VariableUsedVisitor(@NotNull PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (this.used) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
        if (this.used) {
            return;
        }
        super.visitReferenceExpression(referenceExpression);
        if (referenceExpression.isReferenceTo((PsiElement)this.variable)) {
            this.used = true;
        }
    }

    public boolean isUsed() {
        return this.used;
    }

    static boolean isVariableUsedIn(@NotNull PsiVariable variable, @NotNull PsiElement code2) {
        VariableUsedVisitor visitor = new VariableUsedVisitor(variable);
        code2.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }
}

