/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class ChannelResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        return "ChannelOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("channel.opened.not.closed.display.name", new Object[0]);
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"getChannel".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.net.Socket", "java.net.DatagramSocket", "java.net.ServerSocket", "java.net.SocketInputStream", "java.net.SocketOutputStream", "java.io.FileInputStream", "java.io.FileOutputStream", "java.io.RandomAccessFile", "com.sun.corba.se.pept.transport.EventHandler", "sun.nio.ch.InheritedChannel") == null) {
            return false;
        }
        return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.nio.channels.Channel");
    }

    @Override
    protected boolean isResourceFactoryClosed(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (tryStatement == null) {
            return false;
        }
        while (!this.isResourceClosedInFinally(tryStatement, variable)) {
            if ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class})) != null) continue;
            return false;
        }
        return true;
    }
}

