/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignForExtensionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("design.for.extension.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("design.for.extension.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method2 = (PsiMethod)infos[0];
        if (MethodUtils.isOverridden(method2)) {
            return null;
        }
        return new MakeMethodFinalFix(method2.getName());
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DesignForExtensionVisitor();
    }

    private static class DesignForExtensionVisitor
    extends BaseInspectionVisitor {
        private DesignForExtensionVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            if (method2.isConstructor()) {
                return;
            }
            if (method2.hasModifierProperty("private") || method2.hasModifierProperty("final") || method2.hasModifierProperty("abstract") || method2.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum() || containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (containingClass instanceof PsiAnonymousClass) {
                return;
            }
            PsiCodeBlock body2 = method2.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body2)) {
                return;
            }
            this.registerMethodError(method2, method2);
        }
    }

    private static class MakeMethodFinalFix
    extends InspectionGadgetsFix {
        private final String myMethodName;

        public MakeMethodFinalFix(String methodName) {
            this.myMethodName = methodName;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("make.method.final.fix.name", this.myMethodName);
        }

        @NotNull
        public String getFamilyName() {
            return "Make method 'final'";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method2 = (PsiMethod)element;
            PsiModifierList modifierList = method2.getModifierList();
            modifierList.setModifierProperty("final", true);
        }
    }
}

