/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.NotNull;

public class NonFinalCloneInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("non.final.clone.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.final.clone.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonFinalCloneVisitor();
    }

    private static class NonFinalCloneVisitor
    extends BaseInspectionVisitor {
        private NonFinalCloneVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            super.visitMethod(method2);
            if (!CloneUtils.isClone(method2)) {
                return;
            }
            if (method2.hasModifierProperty("final") || method2.hasModifierProperty("abstract")) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final") || containingClass.isInterface()) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

