/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.serialization.ExternalizableWithoutPublicNoArgConstructorInspectionBase;
import org.jetbrains.annotations.NotNull;

public class ExternalizableWithoutPublicNoArgConstructorInspection
extends ExternalizableWithoutPublicNoArgConstructorInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod constructor = (PsiMethod)infos[1];
        if (constructor == null) {
            PsiClass aClass = (PsiClass)infos[0];
            if (aClass instanceof PsiAnonymousClass) {
                return null;
            }
            return new DelegatingFix((LocalQuickFix)new AddDefaultConstructorFix(aClass, "public"));
        }
        return new MakeConstructorPublicFix();
    }

    private static class MakeConstructorPublicFix
    extends InspectionGadgetsFix {
        private MakeConstructorPublicFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("make.constructor.public", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement classNameIdentifier = descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)classNameIdentifier.getParent();
            if (aClass == null) {
                return;
            }
            PsiMethod constructor = ExternalizableWithoutPublicNoArgConstructorInspectionBase.getNoArgConstructor(aClass);
            if (constructor == null) {
                return;
            }
            constructor.getModifierList().setModifierProperty("public", true);
        }
    }
}

