/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class ReadObjectAndWriteObjectPrivateInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonPrivateSerializationMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("readwriteobject.private.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("readwriteobject.private.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectWriteObjectPrivateVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("private");
    }

    private static class ReadObjectWriteObjectPrivateVisitor
    extends BaseInspectionVisitor {
        private ReadObjectWriteObjectPrivateVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (method2.hasModifierProperty("private")) {
                return;
            }
            if (!SerializationUtils.isReadObject(method2) && !SerializationUtils.isWriteObject(method2)) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

