/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertMessageNotStringInspection
extends BaseInspection {
    public boolean onlyWarnOnBoolean = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assert.message.not.string.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        return InspectionGadgetsBundle.message("assert.message.of.type.boolean.problem.descriptor", type2.getPresentableText());
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assert.message.not.string.only.warn.boolean.option", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnBoolean");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertMessageNotStringVisitor();
    }

    private class AssertMessageNotStringVisitor
    extends BaseInspectionVisitor {
        private AssertMessageNotStringVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement2) {
            super.visitAssertStatement(statement2);
            PsiExpression assertDescription = statement2.getAssertDescription();
            if (assertDescription == null) {
                return;
            }
            PsiType type2 = assertDescription.getType();
            if (AssertMessageNotStringInspection.this.onlyWarnOnBoolean) {
                if (PsiType.BOOLEAN.equals((Object)type2)) {
                    this.registerError((PsiElement)assertDescription, type2);
                    return;
                }
                PsiClassType javaLangBoolean = PsiType.BOOLEAN.getBoxedType((PsiElement)statement2);
                if (javaLangBoolean != null && javaLangBoolean.equals((Object)type2)) {
                    this.registerError((PsiElement)assertDescription, type2);
                }
            } else if (type2 != null && !type2.equalsToText("java.lang.String")) {
                this.registerError((PsiElement)assertDescription, type2);
            }
        }
    }
}

