/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CStyleArrayDeclarationInspection
extends BaseInspection {
    public boolean ignoreVariables = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("c.style.array.declaration.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiMethod) {
            return InspectionGadgetsBundle.message("cstyle.array.method.declaration.problem.descriptor", new Object[0]);
        }
        int choice = info instanceof PsiField ? 1 : (info instanceof PsiParameter ? 2 : 3);
        return InspectionGadgetsBundle.message("cstyle.array.variable.declaration.problem.descriptor", choice);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore C-style declarations in variables", (InspectionProfileEntry)this, "ignoreVariables");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CStyleArrayDeclarationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CStyleArrayDeclarationVisitor();
    }

    private class CStyleArrayDeclarationVisitor
    extends BaseInspectionVisitor {
        private CStyleArrayDeclarationVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            if (CStyleArrayDeclarationInspection.this.ignoreVariables) {
                return;
            }
            PsiType declaredType = variable.getType();
            if (declaredType.getArrayDimensions() == 0) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType elementType = typeElement.getType();
            if (elementType.equals(declaredType)) {
                return;
            }
            this.registerVariableError(variable, variable);
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            PsiType returnType = method2.getReturnType();
            if (returnType == null || returnType.getArrayDimensions() == 0) {
                return;
            }
            PsiTypeElement typeElement = method2.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType type2 = typeElement.getType();
            if (type2.equals(returnType)) {
                return;
            }
            this.registerMethodError(method2, method2);
        }
    }

    private static class CStyleArrayDeclarationFix
    extends InspectionGadgetsFix {
        private CStyleArrayDeclarationFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("c.style.array.declaration.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                variable.normalizeDeclaration();
                CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)variable);
            } else if (element instanceof PsiMethod) {
                PsiMethod method2 = (PsiMethod)element;
                PsiTypeElement returnTypeElement = method2.getReturnTypeElement();
                if (returnTypeElement == null) {
                    return;
                }
                PsiType returnType = method2.getReturnType();
                if (returnType == null) {
                    return;
                }
                PsiParameterList child = method2.getParameterList();
                while (!(child instanceof PsiCodeBlock)) {
                    PsiJavaToken token;
                    IElementType tokenType;
                    PsiParameterList element1 = child;
                    child = child.getNextSibling();
                    if (!(element1 instanceof PsiJavaToken) || !JavaTokenType.LBRACKET.equals(tokenType = (token = (PsiJavaToken)element1).getTokenType()) && !JavaTokenType.RBRACKET.equals(tokenType)) continue;
                    token.delete();
                }
                PsiTypeElement typeElement = JavaPsiFacade.getElementFactory((Project)project2).createTypeElement(returnType);
                returnTypeElement.replace((PsiElement)typeElement);
            }
        }
    }
}

