/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class ChainedEqualityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ChainedEqualityComparisons";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("chained.equality.comparisons.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("chained.equality.comparisons.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedEqualityVisitor();
    }

    private static class ChainedEqualityVisitor
    extends BaseInspectionVisitor {
        private ChainedEqualityVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiExpression && ComparisonUtils.isEqualityComparison((PsiExpression)parent)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length >= 3) {
                this.registerError((PsiElement)expression2, new Object[0]);
            } else {
                for (PsiExpression operand2 : operands2) {
                    if (!ComparisonUtils.isEqualityComparison(operand2)) continue;
                    this.registerError((PsiElement)expression2, new Object[0]);
                    break;
                }
            }
        }
    }
}

