/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.style.ControlFlowStatementVisitorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowStatementWithoutBracesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("control.flow.statement.without.braces.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("control.flow.statement.without.braces.problem.descriptor", infos);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 1 && infos[0] instanceof String) {
            return new ControlFlowStatementFix((String)infos[0]);
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ControlFlowStatementVisitor();
    }

    private static class ControlFlowStatementVisitor
    extends ControlFlowStatementVisitorBase {
        private ControlFlowStatementVisitor() {
        }

        @Override
        @Contract(value="null->false")
        protected boolean isApplicable(PsiStatement body2) {
            PsiIfStatement ifStatement;
            PsiElement parent;
            if (body2 instanceof PsiIfStatement && this.isVisibleHighlight((PsiElement)body2) && (parent = body2.getParent()) instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)parent).getElseBranch() == body2) {
                return false;
            }
            return body2 != null && !(body2 instanceof PsiBlockStatement);
        }

        @Override
        @Nullable
        protected Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement body2) {
            if (body2 instanceof PsiLoopStatement || body2 instanceof PsiIfStatement) {
                PsiElement lastChild = body2.getLastChild();
                return Pair.create((Object)PsiTreeUtil.skipSiblingsBackward((PsiElement)body2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}), lastChild instanceof PsiJavaToken && ((PsiJavaToken)lastChild).getTokenType() == JavaTokenType.SEMICOLON ? lastChild : null);
            }
            return null;
        }
    }

    private static class ControlFlowStatementFix
    extends InspectionGadgetsFix {
        private final String myKeywordText;

        private ControlFlowStatementFix(String keywordText) {
            this.myKeywordText = keywordText;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("control.flow.statement.without.braces.message", this.myKeywordText);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("control.flow.statement.without.braces.add.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiStatement statementWithoutBraces;
            PsiStatement statement2;
            PsiElement element = descriptor.getStartElement();
            PsiElement parent = element.getParent();
            if (element instanceof PsiStatement) {
                statement2 = (PsiStatement)element;
            } else if (parent instanceof PsiStatement) {
                statement2 = (PsiStatement)parent;
            } else {
                return;
            }
            if (statement2 instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)statement2;
                statementWithoutBraces = loopStatement.getBody();
            } else if (statement2 instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement2;
                if (element == ifStatement.getElseElement()) {
                    statementWithoutBraces = ifStatement.getElseBranch();
                } else {
                    statementWithoutBraces = ifStatement.getThenBranch();
                    if (statementWithoutBraces == null) {
                        return;
                    }
                    PsiElement nextSibling = statementWithoutBraces.getNextSibling();
                    if (nextSibling instanceof PsiWhiteSpace) {
                        nextSibling.delete();
                    }
                }
            } else {
                return;
            }
            if (statementWithoutBraces == null) {
                return;
            }
            String newStatementText = "{\n" + statementWithoutBraces.getText() + "\n}";
            PsiReplacementUtil.replaceStatement(statementWithoutBraces, newStatementText);
        }
    }
}

