/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaBodyCanBeCodeBlockInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("lambda.body.can.be.code.block.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OneLineLambda2CodeBlockVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new OneLineLambda2CodeBlockFix();
    }

    private static class OneLineLambda2CodeBlockFix
    extends InspectionGadgetsFix {
        private OneLineLambda2CodeBlockFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement body2;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)element).getBody()) instanceof PsiExpression) {
                RefactoringUtil.expandExpressionLambdaToCodeBlock(body2);
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("lambda.body.can.be.code.block.quickfix", new Object[0]);
        }
    }

    private static class OneLineLambda2CodeBlockVisitor
    extends BaseInspectionVisitor {
        private OneLineLambda2CodeBlockVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            super.visitLambdaExpression(lambdaExpression);
            if (lambdaExpression.getBody() instanceof PsiExpression) {
                this.registerError((PsiElement)lambdaExpression, new Object[0]);
            }
        }
    }
}

