/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterTypeCanBeSpecifiedInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.descriptor", infos);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InferLambdaParameterTypeVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InferLambdaParameterTypeFix(infos);
    }

    private static class InferLambdaParameterTypeFix
    extends InspectionGadgetsFix {
        private final Object[] myInfos;

        public InferLambdaParameterTypeFix(Object ... infos) {
            this.myInfos = infos;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.quickfix", this.myInfos);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.family.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiLambdaExpression) {
                LambdaRefactoringUtil.specifyLambdaParameterTypes((PsiLambdaExpression)element);
            }
        }
    }

    private static class InferLambdaParameterTypeVisitor
    extends BaseInspectionVisitor {
        private InferLambdaParameterTypeVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            String inferredTypesText;
            super.visitLambdaExpression(lambdaExpression);
            PsiParameter[] parameters2 = lambdaExpression.getParameterList().getParameters();
            if (parameters2.length == 0) {
                return;
            }
            for (PsiParameter parameter : parameters2) {
                if (parameter.getTypeElement() == null) continue;
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null && LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType) != null && LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)lambdaExpression, (PsiType)functionalInterfaceType) && (inferredTypesText = LambdaRefactoringUtil.createLambdaParameterListWithFormalTypes(functionalInterfaceType, lambdaExpression, true)) != null) {
                this.registerError((PsiElement)lambdaExpression, inferredTypesText);
            }
        }
    }
}

