/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodRefCanBeReplacedWithLambdaInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.ref.can.be.replaced.with.lambda.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodRefToLambdaVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Object info;
        if (infos.length == 1 && (info = infos[0]) instanceof FixFactory) {
            return (InspectionGadgetsFix)((FixFactory)info).create();
        }
        return null;
    }

    private static interface FixFactory
    extends Factory<InspectionGadgetsFix> {
    }

    private static class SideEffectsMethodRefToLambdaFix
    extends MethodRefToLambdaFix {
        private SideEffectsMethodRefToLambdaFix() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        protected void doFix(Project project2, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            AsyncResult contextFromFocus = DataManager.getInstance().getDataContextFromFocus();
            contextFromFocus.doWhenDone(context -> {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
                if (editor != null) {
                    CommandProcessor.getInstance().executeCommand(project2, () -> SideEffectsMethodRefToLambdaFix.doFixAndRemoveSideEffects(editor, methodReferenceExpression), this.getFamilyName(), null);
                }
            });
        }

        private static void doFixAndRemoveSideEffects(@NotNull Editor editor, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{methodReferenceExpression})) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)WriteAction.compute(() -> LambdaRefactoringUtil.convertMethodReferenceToLambda(methodReferenceExpression, false, true));
            if (lambdaExpression != null) {
                LambdaRefactoringUtil.removeSideEffectsFromLambdaBody(editor, lambdaExpression);
            }
        }
    }

    private static class MethodRefToLambdaFix
    extends InspectionGadgetsFix {
        private MethodRefToLambdaFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("method.ref.can.be.replaced.with.lambda.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiMethodReferenceExpression) {
                this.doFix(project2, (PsiMethodReferenceExpression)element);
            }
        }

        protected void doFix(Project project2, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
            LambdaRefactoringUtil.convertMethodReferenceToLambda(methodReferenceExpression, false, true);
        }
    }

    private static class MethodRefToLambdaVisitor
    extends BaseInspectionVisitor {
        private MethodRefToLambdaVisitor() {
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression methodReferenceExpression) {
            super.visitMethodReferenceExpression(methodReferenceExpression);
            if (LambdaRefactoringUtil.canConvertToLambda(methodReferenceExpression)) {
                this.registerError((PsiElement)methodReferenceExpression, MethodRefToLambdaVisitor.getFixFactory(LambdaRefactoringUtil.canConvertToLambdaWithoutSideEffects(methodReferenceExpression), this.isOnTheFly()));
            }
        }

        private static FixFactory getFixFactory(boolean canConvert, boolean onTheFly) {
            if (canConvert) {
                return () -> new MethodRefToLambdaFix();
            }
            if (onTheFly || ApplicationManager.getApplication().isUnitTestMode()) {
                return () -> new SideEffectsMethodRefToLambdaFix();
            }
            return null;
        }
    }
}

