/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RedundantImplementsInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreSerializable = false;
    public boolean ignoreCloneable = false;

    @NotNull
    public String getID() {
        return "RedundantInterfaceDeclaration";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("redundant.implements.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("redundant.implements.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel checkboxOptionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("ignore.serializable.option", new Object[0]), "ignoreSerializable");
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("ignore.cloneable.option", new Object[0]), "ignoreCloneable");
        return checkboxOptionsPanel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantImplementsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantImplementsVisitor();
    }

    private class RedundantImplementsVisitor
    extends BaseInspectionVisitor {
        private RedundantImplementsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isAnnotationType()) {
                return;
            }
            if (aClass.isInterface()) {
                this.checkInterface(aClass);
            } else {
                this.checkConcreteClass(aClass);
            }
        }

        private void checkInterface(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] extendsElements;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement extendsElement : extendsElements = extendsList.getReferenceElements()) {
                this.checkExtendedInterface(extendsElement, extendsElements);
            }
        }

        private void checkConcreteClass(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] implementsElements;
            PsiJavaCodeReferenceElement extendsElement;
            PsiReferenceList extendsList = aClass.getExtendsList();
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (extendsList == null || implementsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] extendsElements = extendsList.getReferenceElements();
            if (extendsElements.length != 1) {
                if (aClass.isEnum()) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                    extendsElement = factory.createReferenceElementByFQClassName("java.lang.Enum", aClass.getResolveScope());
                } else {
                    extendsElement = null;
                }
            } else {
                extendsElement = extendsElements[0];
            }
            for (PsiJavaCodeReferenceElement implementsElement : implementsElements = implementsList.getReferenceElements()) {
                this.checkImplementedClass(implementsElement, extendsElement, implementsElements);
            }
        }

        private void checkImplementedClass(PsiJavaCodeReferenceElement implementsElement, PsiJavaCodeReferenceElement extendsElement, PsiJavaCodeReferenceElement[] implementsElements) {
            PsiElement target = implementsElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass implementedClass = (PsiClass)target;
            if (!implementedClass.isInterface()) {
                return;
            }
            String qualifiedName = implementedClass.getQualifiedName();
            if (RedundantImplementsInspection.this.ignoreSerializable && "java.io.Serializable".equals(qualifiedName)) {
                return;
            }
            if (RedundantImplementsInspection.this.ignoreCloneable && "java.lang.Cloneable".equals(qualifiedName)) {
                return;
            }
            if (extendsElement != null) {
                PsiElement extendsReferent = extendsElement.resolve();
                if (!(extendsReferent instanceof PsiClass)) {
                    return;
                }
                PsiClass extendedClass = (PsiClass)extendsReferent;
                if (extendedClass.isInheritor(implementedClass, true)) {
                    this.registerError((PsiElement)implementsElement, new Object[0]);
                    return;
                }
            }
            for (PsiJavaCodeReferenceElement testImplementElement : implementsElements) {
                PsiClass testImplementedClass;
                PsiElement implementsReferent;
                if (testImplementElement.equals(implementsElement) || !((implementsReferent = testImplementElement.resolve()) instanceof PsiClass) || !(testImplementedClass = (PsiClass)implementsReferent).isInheritor(implementedClass, true)) continue;
                this.registerError((PsiElement)implementsElement, new Object[0]);
                return;
            }
        }

        private void checkExtendedInterface(PsiJavaCodeReferenceElement extendsElement, PsiJavaCodeReferenceElement[] extendsElements) {
            PsiElement target = extendsElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass extendedInterface = (PsiClass)target;
            if (!extendedInterface.isInterface()) {
                return;
            }
            for (PsiJavaCodeReferenceElement testExtendsElement : extendsElements) {
                PsiClass testExtendedInterface;
                PsiElement implementsReferent;
                if (testExtendsElement.equals(extendsElement) || !((implementsReferent = testExtendsElement.resolve()) instanceof PsiClass) || !(testExtendedInterface = (PsiClass)implementsReferent).isInheritor(extendedInterface, true)) continue;
                this.registerError((PsiElement)extendsElement, new Object[0]);
                return;
            }
        }
    }

    private static class RedundantImplementsFix
    extends InspectionGadgetsFix {
        private RedundantImplementsFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("redundant.implements.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement implementReference = descriptor.getPsiElement();
            RedundantImplementsFix.deleteElement(implementReference);
        }
    }
}

