/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.style.StringBufferReplaceableByStringInspectionBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringBufferReplaceableByStringInspection
extends StringBufferReplaceableByStringInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String typeText = ((PsiType)infos[1]).getCanonicalText();
        return new StringBufferReplaceableByStringFix("java.lang.StringBuilder".equals(typeText));
    }

    private static class StringBufferReplaceableByStringFix
    extends InspectionGadgetsFix {
        private final boolean isStringBuilder;
        private final List<PsiComment> leadingComments = new ArrayList<PsiComment>();
        private final List<PsiElement> commentsAndWhitespace = new ArrayList<PsiElement>();

        StringBufferReplaceableByStringFix(boolean isStringBuilder) {
            this.isStringBuilder = isStringBuilder;
        }

        @NotNull
        public String getName() {
            if (this.isStringBuilder) {
                return InspectionGadgetsBundle.message("string.builder.replaceable.by.string.quickfix", new Object[0]);
            }
            return InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with 'String'";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiStatement statement2;
            boolean useVariable;
            PsiCodeBlock codeBlock;
            StringBuilder builder;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiVariable)) {
                if (parent instanceof PsiNewExpression) {
                    PsiExpression stringBuilderExpression = StringBufferReplaceableByStringInspectionBase.getCompleteExpression(parent);
                    this.collectComments((PsiElement)stringBuilderExpression);
                    StringBuilder stringExpression = this.buildStringExpression((PsiElement)stringBuilderExpression, new StringBuilder());
                    if (stringExpression != null && stringBuilderExpression != null) {
                        this.addLeadingCommentsBefore((PsiElement)stringBuilderExpression);
                        this.addTrailingCommentsAfter((PsiElement)stringBuilderExpression);
                        PsiReplacementUtil.replaceExpression(stringBuilderExpression, stringExpression.toString());
                    }
                }
                return;
            }
            PsiVariable variable = (PsiVariable)parent;
            String variableName = variable.getName();
            if (variableName == null) {
                return;
            }
            PsiTypeElement originalTypeElement = variable.getTypeElement();
            if (originalTypeElement == null) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            if (StringBufferReplaceableByStringInspectionBase.isAppendCall((PsiElement)initializer)) {
                this.collectComments(parent);
                builder = this.buildStringExpression((PsiElement)initializer, new StringBuilder());
                if (builder == null) {
                    return;
                }
            } else if (initializer instanceof PsiNewExpression) {
                PsiExpression argument;
                PsiNewExpression newExpression = (PsiNewExpression)initializer;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                PsiExpression[] arguments = argumentList.getExpressions();
                builder = arguments.length == 0 ? new StringBuilder() : (PsiType.INT.equals((Object)(argument = arguments[0]).getType()) ? new StringBuilder() : (ParenthesesUtils.getPrecedence(argument) > 6 ? new StringBuilder("(").append(argument.getText()).append(')') : new StringBuilder(argument.getText())));
            } else {
                return;
            }
            if ((codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
                return;
            }
            StringBuildingVisitor visitor = new StringBuildingVisitor(variable, builder);
            codeBlock.accept((PsiElementVisitor)visitor);
            if (visitor.hadProblem()) {
                return;
            }
            List<PsiMethodCallExpression> expressions2 = visitor.getExpressions();
            String expressionText = builder.toString().trim();
            PsiMethodCallExpression lastExpression = expressions2.get(expressions2.size() - 1);
            boolean bl = useVariable = expressionText.contains("\n") && !StringBufferReplaceableByStringFix.isVariableInitializer((PsiExpression)lastExpression);
            if (useVariable) {
                statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiStatement.class);
                if (statement2 == null) {
                    return;
                }
                String modifier = CodeStyleSettingsManager.getSettings((Project)project2).GENERATE_FINAL_LOCALS ? "final " : "";
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
                StringBuilder statementText = new StringBuilder(modifier).append("java.lang.String").append(' ').append(variableName).append("=");
                for (PsiComment comment : this.leadingComments) {
                    statementText.append(comment.getText());
                    PsiElement sibling = comment.getNextSibling();
                    if (!(sibling instanceof PsiWhiteSpace)) continue;
                    statementText.append(sibling.getText());
                }
                statementText.append(expressionText).append(';');
                PsiStatement newStatement = factory.createStatementFromText(statementText.toString(), (PsiElement)variable);
                codeBlock.addBefore((PsiElement)newStatement, (PsiElement)statement2);
                this.addTrailingCommentsAfter((PsiElement)lastExpression);
                PsiReplacementUtil.replaceExpression((PsiExpression)lastExpression, variableName);
            } else {
                statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)lastExpression, PsiStatement.class);
                if (statement2 == null) {
                    return;
                }
                this.addLeadingCommentsBefore((PsiElement)statement2);
                this.addTrailingCommentsAfter((PsiElement)statement2);
                PsiReplacementUtil.replaceExpression((PsiExpression)lastExpression, expressionText);
            }
            variable.delete();
            int size = expressions2.size() - 1;
            for (int i2 = 0; i2 < size; ++i2) {
                expressions2.get(i2).getParent().delete();
            }
        }

        private static boolean isVariableInitializer(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)parent;
            PsiExpression initializer = variable.getInitializer();
            return initializer == expression2;
        }

        @Nullable
        StringBuilder buildStringExpression(PsiElement element, @NonNls StringBuilder result2) {
            if (element instanceof PsiNewExpression) {
                PsiExpression argument;
                PsiType type2;
                PsiNewExpression newExpression = (PsiNewExpression)element;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return null;
                }
                this.addCommentsBefore((PsiElement)argumentList, result2);
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length == 1 && !PsiType.INT.equals((Object)(type2 = (argument = arguments[0]).getType()))) {
                    if (type2 != null && type2.equalsToText("java.lang.CharSequence")) {
                        result2.append("String.valueOf(").append(argument.getText()).append(')');
                    } else if (ParenthesesUtils.getPrecedence(argument) > 6) {
                        result2.append('(').append(argument.getText()).append(')');
                    } else {
                        result2.append(argument.getText());
                    }
                }
                return result2;
            }
            for (PsiElement child : element.getChildren()) {
                if (child instanceof PsiExpressionList || this.buildStringExpression(child, result2) != null) continue;
                return null;
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String referenceName = methodExpression.getReferenceName();
                if ("toString".equals(referenceName)) {
                    if (result2.length() == 0) {
                        result2.append("\"\"");
                    }
                } else if ("append".equals(referenceName)) {
                    PsiExpression[] arguments = argumentList.getExpressions();
                    if (arguments.length == 0) {
                        return null;
                    }
                    if (arguments.length > 1) {
                        if (result2.length() != 0) {
                            StringBufferReplaceableByStringFix.insertPlus(result2);
                        }
                        this.addCommentsBefore((PsiElement)argumentList, result2);
                        result2.append("String.valueOf").append(argumentList.getText());
                        return result2;
                    }
                    PsiExpression argument = arguments[0];
                    PsiType type3 = argument.getType();
                    String argumentText = argument.getText();
                    if (result2.length() != 0) {
                        StringBufferReplaceableByStringFix.insertPlus(result2);
                        this.addCommentsBefore((PsiElement)argument, result2);
                        if (ParenthesesUtils.getPrecedence(argument) > 6 || type3 instanceof PsiPrimitiveType && ParenthesesUtils.getPrecedence(argument) == 6) {
                            result2.append('(').append(argumentText).append(')');
                        } else if (type3 instanceof PsiArrayType) {
                            result2.append("String.valueOf(").append(argumentText).append(")");
                        } else {
                            if (StringUtil.startsWithChar((CharSequence)argumentText, (char)'+')) {
                                result2.append(' ');
                            }
                            result2.append(argumentText);
                        }
                    } else {
                        this.addCommentsBefore((PsiElement)argumentList, result2);
                        if (type3 instanceof PsiPrimitiveType) {
                            if (argument instanceof PsiLiteralExpression) {
                                PsiLiteralExpression literalExpression = (PsiLiteralExpression)argument;
                                if (PsiType.CHAR.equals((Object)literalExpression.getType())) {
                                    result2.append('\"');
                                    Character c = (Character)literalExpression.getValue();
                                    if (c != null) {
                                        result2.append(StringUtil.escapeStringCharacters((String)c.toString()));
                                    }
                                    result2.append('\"');
                                } else {
                                    result2.append('\"').append(literalExpression.getValue()).append('\"');
                                }
                            } else {
                                result2.append("String.valueOf(").append(argumentText).append(")");
                            }
                        } else if (ParenthesesUtils.getPrecedence(argument) >= 6) {
                            result2.append('(').append(argumentText).append(')');
                        } else if (type3 != null && !type3.equalsToText("java.lang.String")) {
                            result2.append("String.valueOf(").append(argumentText).append(")");
                        } else {
                            result2.append(argumentText);
                        }
                    }
                }
            }
            return result2;
        }

        private void addCommentsBefore(PsiElement anchor, StringBuilder out) {
            PsiElement element;
            int offset = anchor.getTextOffset();
            boolean newlineAdded = false;
            boolean newlineEncountered = false;
            Iterator<PsiElement> iterator = this.commentsAndWhitespace.iterator();
            while (iterator.hasNext() && (element = iterator.next()).getTextOffset() < offset) {
                String text;
                if (element instanceof PsiComment) {
                    PsiComment comment = (PsiComment)element;
                    if (out.length() == 0) {
                        this.leadingComments.add(comment);
                    } else {
                        PsiElement prev = comment.getPrevSibling();
                        if (prev instanceof PsiWhiteSpace) {
                            out.append(prev.getText());
                        }
                        out.append(comment.getText());
                        PsiElement next = comment.getNextSibling();
                        if (next instanceof PsiWhiteSpace) {
                            String text2 = next.getText();
                            if (text2.contains("\n")) {
                                newlineAdded = true;
                            }
                            out.append(text2);
                        }
                    }
                } else if (element instanceof PsiWhiteSpace && (text = element.getText()).contains("\n")) {
                    newlineEncountered = true;
                }
                iterator.remove();
            }
            if (newlineEncountered && !newlineAdded && out.length() != 0) {
                out.append("\n");
            }
        }

        private void addLeadingCommentsBefore(PsiElement anchor) {
            PsiElement parent = anchor.getParent();
            for (PsiComment comment : this.leadingComments) {
                parent.addBefore((PsiElement)comment, anchor);
                PsiElement sibling = comment.getNextSibling();
                if (!(sibling instanceof PsiWhiteSpace)) continue;
                parent.addBefore(sibling, anchor);
            }
            this.leadingComments.clear();
        }

        private void addTrailingCommentsAfter(PsiElement anchor) {
            PsiElement parent = anchor.getParent();
            for (int i2 = this.commentsAndWhitespace.size() - 1; i2 >= 0; --i2) {
                PsiElement element = this.commentsAndWhitespace.get(i2);
                if (!(element instanceof PsiComment)) continue;
                PsiComment comment = (PsiComment)element;
                parent.addAfter((PsiElement)comment, anchor);
                PsiElement sibling = comment.getPrevSibling();
                if (!(sibling instanceof PsiWhiteSpace)) continue;
                parent.addAfter(sibling, anchor);
            }
            this.commentsAndWhitespace.clear();
        }

        void collectComments(PsiElement element) {
            this.commentsAndWhitespace.addAll(PsiTreeUtil.findChildrenOfAnyType((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class}));
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionStatement) && !(parent instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiComment comment = (PsiComment)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PsiComment.class);
            while (comment != null) {
                this.commentsAndWhitespace.add((PsiElement)comment);
                comment = (PsiComment)PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, PsiComment.class);
            }
            PsiElement sibling = parent.getNextSibling();
            if (sibling instanceof PsiWhiteSpace) {
                this.commentsAndWhitespace.add(sibling);
            }
        }

        private static void insertPlus(@NonNls StringBuilder result2) {
            int lastIndex = result2.length() - 1;
            if (result2.charAt(lastIndex) == '\n') {
                int index;
                for (index = result2.length() - 2; index > 0 && result2.charAt(index) != '\n'; --index) {
                }
                boolean insideLiteral = false;
                boolean escape = false;
                while (index < lastIndex) {
                    char c = result2.charAt(index);
                    if (c == '\"' && !escape) {
                        insideLiteral = !insideLiteral;
                    } else {
                        if (c == '\\' && insideLiteral) {
                            escape = true;
                            ++index;
                            continue;
                        }
                        if (!insideLiteral && c == '/' && result2.charAt(index + 1) == '/') {
                            if (index != 0) {
                                result2.insert(index, "+ ");
                            }
                            return;
                        }
                    }
                    ++index;
                    escape = false;
                }
                result2.insert(lastIndex, '+');
            } else {
                result2.append('+');
            }
        }

        private class StringBuildingVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable myVariable;
            private final StringBuilder myBuilder;
            private final List<PsiMethodCallExpression> expressions = ContainerUtil.newArrayList();
            private boolean myProblem;

            StringBuildingVisitor(PsiVariable variable, StringBuilder builder) {
                this.myVariable = variable;
                this.myBuilder = builder;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (this.myProblem) {
                    return;
                }
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression2.resolve();
                if (!this.myVariable.equals(target)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = null;
                PsiElement parent = expression2.getParent();
                PsiElement grandParent = parent.getParent();
                while (parent instanceof PsiReferenceExpression && grandParent instanceof PsiMethodCallExpression) {
                    methodCallExpression = (PsiMethodCallExpression)grandParent;
                    parent = methodCallExpression.getParent();
                    grandParent = parent.getParent();
                    if (!"toString".equals(methodCallExpression.getMethodExpression().getReferenceName())) continue;
                }
                StringBufferReplaceableByStringFix.this.collectComments((PsiElement)methodCallExpression);
                if (StringBufferReplaceableByStringFix.this.buildStringExpression((PsiElement)methodCallExpression, this.myBuilder) == null) {
                    this.myProblem = true;
                }
                this.expressions.add(methodCallExpression);
            }

            public List<PsiMethodCallExpression> getExpressions() {
                return this.expressions;
            }

            boolean hadProblem() {
                return this.myProblem;
            }
        }
    }
}

