/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class TypeParameterExtendsObjectInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("type.parameter.extends.object.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "TypeParameterExplicitlyExtendsObject";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer type2 = (Integer)infos[0];
        if (type2 == 1) {
            return InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor1", new Object[0]);
        }
        return InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor2", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtendsObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsObjectVisitor();
    }

    private static class ExtendsObjectVisitor
    extends BaseInspectionVisitor {
        private ExtendsObjectVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length != 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            if (!extendsType.equalsToText("java.lang.Object")) {
                return;
            }
            PsiIdentifier nameIdentifier = parameter.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            this.registerError((PsiElement)nameIdentifier, 1);
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiElement lastChild = typeElement.getLastChild();
            if (!(lastChild instanceof PsiTypeElement)) {
                return;
            }
            PsiType type2 = typeElement.getType();
            if (!(type2 instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (!wildcardType.isExtends()) {
                return;
            }
            PsiType extendsBound = wildcardType.getBound();
            if (!TypeUtils.isJavaLangObject(extendsBound)) {
                return;
            }
            PsiElement firstChild = typeElement.getFirstChild();
            if (firstChild == null) {
                return;
            }
            this.registerError(firstChild, 2);
        }
    }

    private static class ExtendsObjectFix
    extends InspectionGadgetsFix {
        private ExtendsObjectFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("extends.object.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement identifier = descriptor.getPsiElement();
            PsiElement parent = identifier.getParent();
            if (parent instanceof PsiTypeParameter) {
                PsiJavaCodeReferenceElement[] referenceElements;
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                PsiReferenceList extendsList = typeParameter.getExtendsList();
                for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                    ExtendsObjectFix.deleteElement((PsiElement)referenceElement);
                }
            } else {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement child = typeElement.getLastChild();
                while (child != null) {
                    PsiJavaToken javaToken;
                    IElementType tokenType;
                    if (child instanceof PsiJavaToken && (tokenType = (javaToken = (PsiJavaToken)child).getTokenType()) == JavaTokenType.QUEST) {
                        return;
                    }
                    child.delete();
                    child = typeElement.getLastChild();
                }
            }
        }
    }
}

