/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryInterfaceModifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final Set<String> INTERFACE_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("abstract", "static"));
    private static final Set<String> INNER_CLASS_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "static"));
    private static final Set<String> INNER_INTERFACE_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "abstract", "static"));
    private static final Set<String> FIELD_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "static", "final"));
    private static final Set<String> METHOD_REDUNDANT_MODIFIERS = new HashSet<String>(Arrays.asList("public", "abstract"));

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.interface.modifier.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiModifierList modifierList = (PsiModifierList)infos[1];
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass != null) {
                if (aClass.isInterface()) {
                    return InspectionGadgetsBundle.message("unnecessary.interface.modifier.inner.interface.of.interface.problem.descriptor", new Object[0]);
                }
                return InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor3", new Object[0]);
            }
            return InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor", new Object[0]);
        }
        if (parent instanceof PsiMethod) {
            return InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor2", new Object[0]);
        }
        return InspectionGadgetsBundle.message("unnecessary.interface.modifier.problem.descriptor4", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInterfaceModifierVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryInterfaceModifiersFix((String)infos[0]);
    }

    private static class UnnecessaryInterfaceModifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInterfaceModifierVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass parent = ClassUtils.getContainingClass((PsiElement)aClass);
            if (parent != null && parent.isInterface()) {
                PsiModifierList modifiers = aClass.getModifierList();
                if (aClass.isInterface()) {
                    this.checkForRedundantModifiers(modifiers, INNER_INTERFACE_REDUNDANT_MODIFIERS);
                } else {
                    this.checkForRedundantModifiers(modifiers, INNER_CLASS_REDUNDANT_MODIFIERS);
                }
            } else if (aClass.isInterface()) {
                PsiModifierList modifiers = aClass.getModifierList();
                this.checkForRedundantModifiers(modifiers, INTERFACE_REDUNDANT_MODIFIERS);
            }
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!containingClass.isInterface()) {
                return;
            }
            PsiModifierList modifiers = field.getModifierList();
            this.checkForRedundantModifiers(modifiers, FIELD_REDUNDANT_MODIFIERS);
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (!aClass.isInterface()) {
                return;
            }
            PsiModifierList modifiers = method2.getModifierList();
            this.checkForRedundantModifiers(modifiers, METHOD_REDUNDANT_MODIFIERS);
        }

        public void checkForRedundantModifiers(PsiModifierList list, Set<String> modifiers) {
            if (list == null) {
                return;
            }
            PsiElement[] children2 = list.getChildren();
            StringBuilder redundantModifiers = new StringBuilder();
            for (PsiElement child : children2) {
                String modifierText = child.getText();
                if (!modifiers.contains(modifierText)) continue;
                if (redundantModifiers.length() > 0) {
                    redundantModifiers.append(' ');
                }
                redundantModifiers.append(modifierText);
            }
            for (PsiElement child : children2) {
                if (!modifiers.contains(child.getText())) continue;
                this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{redundantModifiers.toString(), list});
            }
        }
    }

    private static class UnnecessaryInterfaceModifiersFix
    extends InspectionGadgetsFix {
        private final String modifiersText;

        private UnnecessaryInterfaceModifiersFix(String modifiersText) {
            this.modifiersText = modifiersText;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", this.modifiersText);
        }

        @NotNull
        public String getFamilyName() {
            return "Remove unnecessary modifiers";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiModifierList modifierList;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiModifierList) {
                modifierList = (PsiModifierList)element;
            } else {
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiModifierList)) {
                    return;
                }
                modifierList = (PsiModifierList)parent;
            }
            PsiElement modifierOwner = modifierList.getParent();
            if (!(modifierOwner instanceof PsiMethod) || !PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierList)) {
                modifierList.setModifierProperty("static", false);
            }
            assert (modifierOwner != null);
            if (modifierOwner instanceof PsiClass) {
                PsiClass containingClass;
                PsiClass aClass = (PsiClass)modifierOwner;
                if (aClass.isInterface()) {
                    modifierList.setModifierProperty("abstract", false);
                }
                if ((containingClass = ClassUtils.getContainingClass(modifierOwner)) != null && containingClass.isInterface()) {
                    modifierList.setModifierProperty("public", false);
                }
            } else if (modifierOwner instanceof PsiMethod) {
                modifierList.setModifierProperty("abstract", false);
                modifierList.setModifierProperty("public", false);
            } else {
                modifierList.setModifierProperty("public", false);
                modifierList.setModifierProperty("final", false);
            }
        }
    }
}

