/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryToStringCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.tostring.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text = (String)infos[0];
        return InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.descriptor", text);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String text = (String)infos[0];
        return new UnnecessaryToStringCallFix(text);
    }

    @NonNls
    static String calculateReplacementText(PsiExpression expression2) {
        if (expression2 == null) {
            return "this";
        }
        return expression2.getText();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryToStringCallVisitor();
    }

    private static class UnnecessaryToStringCallVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryToStringCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"toString".equals(referenceName)) {
                return;
            }
            PsiElement referenceNameElement = methodExpression.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (qualifier.getType() instanceof PsiArrayType) {
                return;
            }
            if (qualifier instanceof PsiSuperExpression) {
                return;
            }
            boolean throwable = TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Throwable");
            if (ExpressionUtils.isConversionToStringNecessary((PsiExpression)expression2, throwable)) {
                return;
            }
            this.registerError(referenceNameElement, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{UnnecessaryToStringCallInspection.calculateReplacementText(qualifier)});
        }
    }

    private static class UnnecessaryToStringCallFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        private UnnecessaryToStringCallFix(String replacementText) {
            this.replacementText = replacementText;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("unnecessary.call.to.string.valueof.quickfix", this.replacementText);
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)descriptor.getPsiElement().getParent().getParent();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, "this");
            } else {
                methodCallExpression.replace((PsiElement)qualifier);
            }
        }
    }
}

