/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddThisQualifierFix;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedFieldAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unqualified.field.access.display.name", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedFieldAccessVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unqualified.field.access.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddThisQualifierFix();
    }

    private static class UnqualifiedFieldAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiClass expressionClass;
            super.visitReferenceExpression(expression2);
            PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
            if (qualifierExpression2 != null) {
                return;
            }
            PsiReferenceParameterList parameterList = expression2.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiElement element = expression2.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("static")) {
                return;
            }
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)fieldClass) && (expressionClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class)) != null && !expressionClass.equals(fieldClass)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

