/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedInnerClassAccessInspectionBase
extends BaseInspection {
    public boolean ignoreReferencesToLocalInnerClasses = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unqualified.inner.class.access.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unqualified.inner.class.access.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedInnerClassAccessVisitor();
    }

    private class UnqualifiedInnerClassAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedInnerClassAccessVisitor() {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (!aClass.hasModifierProperty("static") && reference.getParent() instanceof PsiNewExpression) {
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (UnqualifiedInnerClassAccessInspectionBase.this.ignoreReferencesToLocalInnerClasses) {
                if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)reference, (boolean)true)) {
                    return;
                }
                PsiClass referenceClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
                if (referenceClass != null && referenceClass.isInheritor(containingClass, true)) {
                    return;
                }
            }
            this.registerError((PsiElement)reference, containingClass.getName());
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }
    }
}

