/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddThisQualifierFix;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedMethodAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unqualified.method.access.display.name", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedMethodAccessVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unqualified.method.access.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddThisQualifierFix();
    }

    private static class UnqualifiedMethodAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedMethodAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiClass expressionClass;
            super.visitReferenceExpression(expression2);
            PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
            if (qualifierExpression2 != null) {
                return;
            }
            PsiReferenceParameterList parameterList = expression2.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiElement element = expression2.resolve();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method2 = (PsiMethod)element;
            if (method2.isConstructor() || method2.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) && ((expressionClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class)) == null || !expressionClass.equals(containingClass))) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

