/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedStaticUsageInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreStaticFieldAccesses = false;
    public boolean m_ignoreStaticMethodCalls = false;
    public boolean m_ignoreStaticAccessFromStaticContext = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unqualified.static.usage.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (infos[0] instanceof PsiMethodCallExpression) {
            return InspectionGadgetsBundle.message("unqualified.static.usage.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("unqualified.static.usage.problem.descriptor1", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unqualified.static.usage.ignore.field.option", new Object[0]), "m_ignoreStaticFieldAccesses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unqualified.static.usage.ignore.method.option", new Object[0]), "m_ignoreStaticMethodCalls");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unqualified,static.usage.only.report.static.usages.option", new Object[0]), "m_ignoreStaticAccessFromStaticContext");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedStaticCallVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos[0] instanceof PsiMethodCallExpression) {
            return new UnqualifiedStaticAccessFix(false);
        }
        return new UnqualifiedStaticAccessFix(true);
    }

    private class UnqualifiedStaticCallVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedStaticCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticMethodCalls) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            if (!this.isUnqualifiedStaticAccess(methodExpression)) {
                return;
            }
            this.registerError((PsiElement)methodExpression, expression2);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticFieldAccesses) {
                return;
            }
            PsiElement element = expression2.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("final") && PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2)) {
                return;
            }
            if (!this.isUnqualifiedStaticAccess(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private boolean isUnqualifiedStaticAccess(PsiReferenceExpression expression2) {
            PsiMember member;
            if (UnqualifiedStaticUsageInspection.this.m_ignoreStaticAccessFromStaticContext && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class)) != null && member.hasModifierProperty("static")) {
                return false;
            }
            PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
            if (qualifierExpression2 != null) {
                return false;
            }
            JavaResolveResult resolveResult = expression2.advancedResolve(false);
            PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
            if (currentFileResolveScope instanceof PsiImportStaticStatement) {
                return false;
            }
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiField) && !(element instanceof PsiMethod)) {
                return false;
            }
            PsiMember member2 = (PsiMember)element;
            if (member2 instanceof PsiEnumConstant && expression2.getParent() instanceof PsiSwitchLabelStatement) {
                return false;
            }
            return member2.hasModifierProperty("static");
        }
    }

    private static class UnqualifiedStaticAccessFix
    extends InspectionGadgetsFix {
        private final boolean m_fixField;

        UnqualifiedStaticAccessFix(boolean fixField) {
            this.m_fixField = fixField;
        }

        @NotNull
        public String getName() {
            if (this.m_fixField) {
                return InspectionGadgetsBundle.message("unqualified.static.usage.qualify.field.quickfix", new Object[0]);
            }
            return InspectionGadgetsBundle.message("unqualified.static.usage.qualify.method.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return "Qualify static access";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression expression2 = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiMember member = (PsiMember)expression2.resolve();
            assert (member != null);
            PsiClass containingClass = member.getContainingClass();
            assert (containingClass != null);
            String className = containingClass.getName();
            String text = expression2.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, className + '.' + text);
        }
    }
}

