/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import org.jetbrains.annotations.NotNull;

public class PublicFieldAccessedInSynchronizedContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("public.field.accessed.in.synchronized.context.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "NonPrivateFieldAccessedInSynchronizedContext";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("public.field.accessed.in.synchronized.context.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldAccessedInSynchronizedContextVisitor();
    }

    private static class PublicFieldAccessedInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private PublicFieldAccessedInSynchronizedContextVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return;
            }
            PsiElement element = expression2.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("private") || field.hasModifierProperty("final")) {
                return;
            }
            if (!SynchronizationUtil.isInSynchronizedContext((PsiElement)expression2)) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || containingClass.hasModifierProperty("private")) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

