/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnStaticFieldInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("synchronization.on.static.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("synchronization.on.static.field.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnStaticFieldVisitor();
    }

    private static class SynchronizationOnStaticFieldVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnStaticFieldVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
            super.visitSynchronizedStatement(statement2);
            PsiExpression lockExpression2 = statement2.getLockExpression();
            if (!(lockExpression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression expression2 = (PsiReferenceExpression)lockExpression2;
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)lockExpression2, new Object[0]);
        }
    }
}

