/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemRunFinalizersOnExitInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToSystemRunFinalizersOnExit";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("system.run.finalizers.on.exit.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("system.run.finalizers.on.exit.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemRunFinalizersOnExitVisitor();
    }

    private static class SystemRunFinalizersOnExitVisitor
    extends BaseInspectionVisitor {
        private SystemRunFinalizersOnExitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!SystemRunFinalizersOnExitVisitor.isRunFinalizersOnExit(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean isRunFinalizersOnExit(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String runFinalizers = "runFinalizersOnExit";
            if (!"runFinalizersOnExit".equals(methodName)) {
                return false;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 == null) {
                return false;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.System".equals(className);
        }
    }
}

