/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

class ThreadingUtils {
    private ThreadingUtils() {
    }

    public static boolean isWaitCall(@NotNull PsiMethodCallExpression expression2) {
        PsiType parameterType;
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"wait".equals(methodName)) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        int numParams = parameterList.getParametersCount();
        if (numParams > 2) {
            return false;
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (numParams > 0 && !(parameterType = parameters2[0].getType()).equals(PsiType.LONG)) {
            return false;
        }
        return numParams <= 1 || (parameterType = parameters2[1].getType()).equals(PsiType.INT);
    }

    public static boolean isNotifyOrNotifyAllCall(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"notify".equals(methodName) && !"notifyAll".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        return args.length == 0;
    }

    public static boolean isSignalOrSignalAllCall(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"signal".equals(methodName) && !"signalAll".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length != 0) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.concurrent.locks.Condition");
    }

    public static boolean isAwaitCall(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!("await".equals(methodName) || "awaitUntil".equals(methodName) || "awaitUninterruptibly".equals(methodName) || "awaitNanos".equals(methodName))) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.concurrent.locks.Condition");
    }
}

