/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class VolatileLongOrDoubleFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("volatile.long.or.double.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String typeString = type2.getPresentableText();
        return InspectionGadgetsBundle.message("volatile.field.problem.descriptor", typeString);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VolatileLongOrDoubleFieldVisitor();
    }

    private static class VolatileLongOrDoubleFieldVisitor
    extends BaseInspectionVisitor {
        private VolatileLongOrDoubleFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("volatile")) {
                return;
            }
            PsiType type2 = field.getType();
            if (PsiType.LONG.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2)) {
                this.registerFieldError(field, type2);
            }
        }
    }
}

