/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public class WaitCalledOnConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("wait.called.on.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("wait.called.on.condition.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitCalledOnConditionVisitor();
    }

    private static class WaitCalledOnConditionVisitor
    extends BaseInspectionVisitor {
        private WaitCalledOnConditionVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isWaitCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.concurrent.locks.Condition")) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

