/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileLoopSpinsOnFieldInspection
extends BaseInspection {
    public boolean ignoreNonEmtpyLoops = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("while.loop.spins.on.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("while.loop.spins.on.field.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("while.loop.spins.on.field.ignore.non.empty.loops.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonEmtpyLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileLoopSpinsOnFieldVisitor();
    }

    private class WhileLoopSpinsOnFieldVisitor
    extends BaseInspectionVisitor {
        private WhileLoopSpinsOnFieldVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiStatement body2 = statement2.getBody();
            if (WhileLoopSpinsOnFieldInspection.this.ignoreNonEmtpyLoops && !this.statementIsEmpty(body2)) {
                return;
            }
            PsiExpression condition2 = statement2.getCondition();
            PsiField field = this.getFieldIfSimpleFieldComparison(condition2);
            if (field == null) {
                return;
            }
            if (body2 != null && (VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)body2) || this.containsWaitCall((PsiElement)body2))) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        private boolean containsWaitCall(PsiElement element) {
            final boolean[] result2 = new boolean[1];
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (ThreadingUtils.isWaitCall(expression2)) {
                        result2[0] = true;
                        this.stopWalking();
                    }
                }
            });
            return result2[0];
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldComparison(PsiExpression condition2) {
            if ((condition2 = PsiUtil.deparenthesizeExpression((PsiExpression)condition2)) == null) {
                return null;
            }
            PsiField field = this.getFieldIfSimpleFieldAccess(condition2);
            if (field != null) {
                return field;
            }
            if (condition2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition2;
                PsiExpression operand2 = prefixExpression.getOperand();
                return this.getFieldIfSimpleFieldComparison(operand2);
            }
            if (condition2 instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)condition2;
                PsiExpression operand3 = postfixExpression.getOperand();
                return this.getFieldIfSimpleFieldComparison(operand3);
            }
            if (condition2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isLiteral(rOperand)) {
                    return this.getFieldIfSimpleFieldComparison(lOperand);
                }
                if (ExpressionUtils.isLiteral(lOperand)) {
                    return this.getFieldIfSimpleFieldComparison(rOperand);
                }
                return null;
            }
            return null;
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldAccess(PsiExpression expression2) {
            if ((expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)expression2)) == null) {
                return null;
            }
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
            PsiExpression qualifierExpression2 = reference.getQualifierExpression();
            if (qualifierExpression2 != null) {
                return null;
            }
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (field.hasModifierProperty("volatile")) {
                return null;
            }
            return field;
        }

        private boolean statementIsEmpty(PsiStatement statement2) {
            if (statement2 == null) {
                return false;
            }
            if (statement2 instanceof PsiEmptyStatement) {
                return true;
            }
            if (statement2 instanceof PsiBlockStatement) {
                PsiStatement[] codeBlockStatements;
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                for (PsiStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                    if (this.statementIsEmpty(codeBlockStatement)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

