/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmbiguousFieldAccessInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("ambiguous.field.access.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass fieldClass = (PsiClass)infos[0];
        PsiVariable variable = (PsiVariable)infos[1];
        if (variable instanceof PsiLocalVariable) {
            return InspectionGadgetsBundle.message("ambiguous.field.access.hides.local.variable.problem.descriptor", fieldClass.getName());
        }
        if (variable instanceof PsiParameter) {
            return InspectionGadgetsBundle.message("ambiguous.field.access.hides.parameter.problem.descriptor", fieldClass.getName());
        }
        return InspectionGadgetsBundle.message("ambiguous.field.access.hides.field.problem.descriptor", fieldClass.getName());
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AmbiguousMethodCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousFieldAccessVisitor();
    }

    private static class AmbiguousFieldAccessVisitor
    extends BaseInspectionVisitor {
        private AmbiguousFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            String referenceText;
            super.visitReferenceExpression(expression2);
            if (expression2.isQualified()) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (target == null) {
                return;
            }
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            if (containingClass == null) {
                return;
            }
            if (!containingClass.isInheritor(fieldClass, true)) {
                return;
            }
            PsiElement parent = containingClass.getParent();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getResolveHelper();
            PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(referenceText = expression2.getText(), parent);
            if (variable == null || field == variable) {
                return;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)variable, (PsiElement)containingClass);
            if (commonParent == null) {
                return;
            }
            this.registerError((PsiElement)expression2, fieldClass, variable);
        }
    }

    private static class AmbiguousMethodCallFix
    extends InspectionGadgetsFix {
        private AmbiguousMethodCallFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("ambiguous.field.access.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String newExpressionText = "super." + referenceExpression.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, newExpressionText);
        }
    }
}

