/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethodParametersHidingInstanceFields = true;
    public boolean m_ignoreForConstructors = false;
    public boolean m_ignoreForPropertySetters = false;
    public boolean m_ignoreForAbstractMethods = false;

    @NotNull
    public String getID() {
        return "ParameterHidesMemberVariable";
    }

    @Nullable
    public String getAlternativeID() {
        return "hiding";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("parameter.hides.member.variable.display.name", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        return InspectionGadgetsBundle.message("parameter.hides.member.variable.problem.descriptor", aClass.getName());
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.setters.option", new Object[0]), "m_ignoreForPropertySetters");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.superclass.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.constructors.option", new Object[0]), "m_ignoreForConstructors");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.abstract.methods.option", new Object[0]), "m_ignoreForAbstractMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.static.parameters.option", new Object[0]), "m_ignoreStaticMethodParametersHidingInstanceFields");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterHidingMemberVariableVisitor();
    }

    private class ParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private ParameterHidingMemberVariableVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiClass aClass;
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return;
            }
            PsiMethod method2 = (PsiMethod)declarationScope;
            if (ParameterHidingMemberVariableInspectionBase.this.m_ignoreForConstructors && method2.isConstructor()) {
                return;
            }
            if (ParameterHidingMemberVariableInspectionBase.this.m_ignoreForAbstractMethods) {
                if (method2.hasModifierProperty("abstract")) {
                    return;
                }
                PsiClass containingClass = method2.getContainingClass();
                if (containingClass != null && containingClass.isInterface()) {
                    return;
                }
            }
            if (ParameterHidingMemberVariableInspectionBase.this.m_ignoreForPropertySetters) {
                String methodName = method2.getName();
                if (methodName.startsWith("set") && PsiType.VOID.equals((Object)method2.getReturnType())) {
                    return;
                }
                if (PropertyUtil.isSimplePropertySetter((PsiMethod)method2)) {
                    return;
                }
            }
            if ((aClass = this.checkFieldName((PsiVariable)variable, method2)) == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldName(PsiVariable variable, PsiMethod method2) {
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)method2);
            while (aClass != null) {
                PsiField field = aClass.findFieldByName(variableName, true);
                if (!(field == null || ParameterHidingMemberVariableInspectionBase.this.m_ignoreStaticMethodParametersHidingInstanceFields && !field.hasModifierProperty("static") && method2.hasModifierProperty("static") || ParameterHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass))) {
                    return aClass;
                }
                if (aClass.hasModifierProperty("static") && ParameterHidingMemberVariableInspectionBase.this.m_ignoreStaticMethodParametersHidingInstanceFields) {
                    return null;
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }
    }
}

