/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.base;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Intention
extends BaseElementAtCaretIntentionAction {
    private final PsiElementPredicate predicate = this.getElementPredicate();

    protected Intention() {
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiElement matchingElement = this.findMatchingElement(element, editor);
        if (matchingElement == null) {
            return;
        }
        this.processIntention(editor, matchingElement);
    }

    protected abstract void processIntention(@NotNull PsiElement var1);

    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        this.processIntention(element);
    }

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull PsiExpression expression2) {
        String expString;
        Project project2 = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression expressionToReplace = expression2;
        if (BoolUtils.isNegated(expression2)) {
            expressionToReplace = BoolUtils.findNegation(expressionToReplace);
            expString = newExpression;
        } else {
            PsiElement parent = expressionToReplace.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expressionToReplace = (PsiExpression)parent;
                parent = parent.getParent();
            }
            expString = "!(" + newExpression + ')';
        }
        PsiExpression newCall = factory.createExpressionFromText(expString, (PsiElement)expression2);
        assert (expressionToReplace != null);
        PsiElement insertedElement = expressionToReplace.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        codeStyleManager.reformat(insertedElement);
    }

    @Nullable
    PsiElement findMatchingElement(@Nullable PsiElement element, Editor editor) {
        while (element != null && JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            if (this.predicate instanceof PsiElementEditorPredicate ? ((PsiElementEditorPredicate)this.predicate).satisfiedBy(element, editor) : this.predicate.satisfiedBy(element)) {
                return element;
            }
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        return this.findMatchingElement(element, editor) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private String getPrefix() {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        String name = aClass.getSimpleName();
        StringBuilder buffer = new StringBuilder(name.length() + 10);
        buffer.append(Character.toLowerCase(name.charAt(0)));
        for (int i2 = 1; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    public String getText() {
        return IntentionPowerPackBundle.message(this.getPrefix() + ".name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return IntentionPowerPackBundle.defaultableMessage(this.getPrefix() + ".family.name", new Object[0]);
    }
}

