/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ComparisonPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipComparisonIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        String operatorText = "";
        String flippedOperatorText = "";
        PsiBinaryExpression expression2 = (PsiBinaryExpression)element;
        if (expression2 != null) {
            PsiJavaToken sign = expression2.getOperationSign();
            operatorText = sign.getText();
            flippedOperatorText = ComparisonUtils.getFlippedComparison(sign.getTokenType());
        }
        if (operatorText.equals(flippedOperatorText)) {
            return IntentionPowerPackBundle.message("flip.smth.intention.name", operatorText);
        }
        return IntentionPowerPackBundle.message("flip.comparison.intention.name", operatorText, flippedOperatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression expression2 = (PsiBinaryExpression)element;
        PsiExpression lhs = expression2.getLOperand();
        PsiExpression rhs = expression2.getROperand();
        IElementType tokenType = expression2.getOperationTokenType();
        assert (rhs != null);
        String expString = rhs.getText() + ComparisonUtils.getFlippedComparison(tokenType) + lhs.getText();
        PsiReplacementUtil.replaceExpression((PsiExpression)expression2, expString);
    }
}

