/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.chartostring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.chartostring.StringToCharPredicate;
import org.jetbrains.annotations.NotNull;

public class StringToCharIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new StringToCharPredicate();
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiLiteralExpression stringLiteral = (PsiLiteralExpression)element;
        String stringLiteralText = stringLiteral.getText();
        String charLiteral = StringToCharIntention.charForStringLiteral(stringLiteralText);
        PsiReplacementUtil.replaceExpression((PsiExpression)stringLiteral, charLiteral);
    }

    private static String charForStringLiteral(String stringLiteral) {
        if ("\"'\"".equals(stringLiteral)) {
            return "'\\''";
        }
        if ("\"\\\"\"".equals(stringLiteral)) {
            return "'\"'";
        }
        return '\'' + stringLiteral.substring(1, stringLiteral.length() - 1) + '\'';
    }
}

