/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.Nullable;

class CallSequencePredicate
implements PsiElementPredicate {
    CallSequencePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiStatement statement2 = (PsiStatement)element;
        PsiStatement nextSibling = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
        if (nextSibling == null) {
            return false;
        }
        PsiVariable variable1 = CallSequencePredicate.getVariable(statement2);
        if (variable1 == null) {
            return false;
        }
        PsiVariable variable2 = CallSequencePredicate.getVariable(nextSibling);
        return variable1.equals(variable2);
    }

    @Nullable
    private static PsiVariable getVariable(PsiStatement statement2) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression2 = expressionStatement.getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        return CallSequencePredicate.getVariable(methodCallExpression);
    }

    @Nullable
    private static PsiVariable getVariable(PsiMethodCallExpression methodCallExpression) {
        PsiType type2 = methodCallExpression.getType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return null;
        }
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (!aClass.equals(containingClass)) {
            return null;
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (qualifierExpression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)qualifierExpression2;
            return CallSequencePredicate.getVariable(expression2);
        }
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return null;
        }
        return (PsiVariable)target;
    }
}

