/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.MethodCallChainPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MakeCallChainIntoCallSequenceIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MethodCallChainPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean showRenameTemplate;
        String variableDeclaration;
        String firstStatement;
        PsiStatement appendStatement;
        String targetText;
        ArrayList<String> callTexts = new ArrayList<String>();
        PsiExpression root = (PsiExpression)element;
        while (root instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)root;
            PsiExpressionList arguments = methodCallExpression.getArgumentList();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            callTexts.add(methodExpression.getReferenceName() + arguments.getText());
            root = methodExpression.getQualifierExpression();
            if (root != null) continue;
            return;
        }
        PsiType rootType = root.getType();
        if (rootType == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            targetText = root.getText();
            appendStatement = (PsiStatement)parent;
            firstStatement = null;
            variableDeclaration = null;
            showRenameTemplate = false;
        } else {
            PsiElement grandParent = parent.getParent();
            appendStatement = (PsiStatement)grandParent;
            if (parent instanceof PsiAssignmentExpression && grandParent instanceof PsiExpressionStatement) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignment.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression expression2 = (PsiReferenceExpression)lhs;
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                PsiType variableType = variable.getType();
                if (variableType.equals(rootType)) {
                    targetText = lhs.getText();
                    PsiJavaToken token = assignment.getOperationSign();
                    firstStatement = targetText + token.getText() + root.getText() + ';';
                    showRenameTemplate = false;
                } else {
                    targetText = "x";
                    showRenameTemplate = true;
                    Project project2 = element.getProject();
                    CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
                    firstStatement = codeStyleSettings.GENERATE_FINAL_LOCALS ? "final " + rootType.getCanonicalText() + ' ' + targetText + '=' + root.getText() + ';' : rootType.getCanonicalText() + ' ' + targetText + '=' + root.getText() + ';';
                }
                variableDeclaration = null;
            } else {
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)appendStatement;
                PsiVariable variable = (PsiVariable)declaration2.getDeclaredElements()[0];
                PsiType variableType = variable.getType();
                if (variableType.equals(rootType)) {
                    targetText = variable.getName();
                    firstStatement = variable.hasModifierProperty("final") ? "final " + variableType.getCanonicalText() + ' ' + variable.getName() + '=' + root.getText() + ';' : variableType.getCanonicalText() + ' ' + variable.getName() + '=' + root.getText() + ';';
                    variableDeclaration = null;
                    showRenameTemplate = false;
                } else {
                    variableDeclaration = variable.hasModifierProperty("final") ? "final " + variableType.getCanonicalText() + ' ' + variable.getName() + '=' : variableType.getCanonicalText() + ' ' + variable.getName() + '=';
                    targetText = "x";
                    showRenameTemplate = true;
                    Project project3 = element.getProject();
                    CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project3);
                    firstStatement = codeStyleSettings.GENERATE_FINAL_LOCALS ? "final " + rootType.getCanonicalText() + " x=" + root.getText() + ';' : rootType.getCanonicalText() + " x=" + root.getText() + ';';
                }
            }
        }
        StringBuilder builder = new StringBuilder("{\n");
        if (firstStatement != null) {
            builder.append(firstStatement);
        }
        Collections.reverse(callTexts);
        int size = callTexts.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String callText = (String)callTexts.get(i2);
            if (i2 == size - 1 && variableDeclaration != null) {
                builder.append(variableDeclaration);
            }
            builder.append(targetText).append('.').append(callText).append(";\n");
        }
        builder.append('}');
        PsiManager manager = element.getManager();
        Project project4 = manager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project4);
        PsiElement appendStatementParent = appendStatement.getParent();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText(builder.toString(), (PsiElement)appendStatement);
        if (appendStatementParent instanceof PsiLoopStatement || appendStatementParent instanceof PsiIfStatement) {
            PsiElement insertedCodeBlock = appendStatement.replace((PsiElement)codeBlock);
            PsiCodeBlock reformattedCodeBlock = (PsiCodeBlock)codeStyleManager.reformat(insertedCodeBlock);
            if (showRenameTemplate) {
                PsiStatement[] statements = reformattedCodeBlock.getStatements();
                PsiVariable variable = (PsiVariable)((PsiDeclarationStatement)statements[0]).getDeclaredElements()[0];
                HighlightUtil.showRenameTemplate(appendStatementParent, (PsiNameIdentifierOwner)variable);
            }
        } else {
            PsiStatement[] statements = codeBlock.getStatements();
            PsiVariable variable = null;
            int length = statements.length;
            for (int i3 = 0; i3 < length; ++i3) {
                PsiElement insertedStatement = appendStatementParent.addBefore((PsiElement)statements[i3], (PsiElement)appendStatement);
                if (i3 == 0 && showRenameTemplate) {
                    variable = (PsiVariable)((PsiDeclarationStatement)insertedStatement).getDeclaredElements()[0];
                }
                codeStyleManager.reformat(insertedStatement);
            }
            appendStatement.delete();
            if (variable != null) {
                HighlightUtil.showRenameTemplate(appendStatementParent, variable);
            }
        }
    }
}

