/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.CallSequencePredicate;
import org.jetbrains.annotations.NotNull;

public class MergeCallSequenceToChainIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new CallSequencePredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (!(element instanceof PsiExpressionStatement)) {
            return;
        }
        PsiExpressionStatement statement2 = (PsiExpressionStatement)element;
        PsiExpressionStatement nextSibling = (PsiExpressionStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiExpressionStatement.class);
        if (nextSibling == null) {
            return;
        }
        PsiExpression expression2 = statement2.getExpression();
        StringBuilder newMethodCallExpression = new StringBuilder(expression2.getText());
        PsiExpression expression1 = nextSibling.getExpression();
        if (!(expression1 instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = MergeCallSequenceToChainIntention.getRootMethodCallExpression((PsiMethodCallExpression)expression1);
        while (true) {
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            newMethodCallExpression.append('.').append(methodName).append(argumentList.getText());
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCallExpression.getParent());
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) break;
            methodCallExpression = (PsiMethodCallExpression)grandParent;
        }
        PsiReplacementUtil.replaceExpression(expression2, newMethodCallExpression.toString());
        nextSibling.delete();
    }

    private static PsiMethodCallExpression getRootMethodCallExpression(PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (qualifierExpression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifierExpression2;
            return MergeCallSequenceToChainIntention.getRootMethodCallExpression(methodCallExpression);
        }
        return expression2;
    }
}

